/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrClosureType
extends GrLiteralClassType {
    private final GrSignature mySignature;
    private volatile PsiType[] myTypeArgs;
    private GrClosableBlock myClosure;
    private static boolean ourForbidClosureInference;

    private GrClosureType(@NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrSignature closureSignature, boolean shouldInferTypeParameters) {
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GrClosureType.$$$reportNull$$$0(1);
        }
        if (facade == null) {
            GrClosureType.$$$reportNull$$$0(2);
        }
        if (closureSignature == null) {
            GrClosureType.$$$reportNull$$$0(3);
        }
        super(languageLevel, scope, facade);
        this.mySignature = closureSignature;
        if (!shouldInferTypeParameters) {
            this.myTypeArgs = PsiType.EMPTY_ARRAY;
        }
    }

    private GrClosureType(@NotNull LanguageLevel level, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrSignature signature, @Nullable PsiType[] typeArgs) {
        if (level == null) {
            GrClosureType.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GrClosureType.$$$reportNull$$$0(5);
        }
        if (facade == null) {
            GrClosureType.$$$reportNull$$$0(6);
        }
        if (signature == null) {
            GrClosureType.$$$reportNull$$$0(7);
        }
        super(level, scope, facade);
        this.mySignature = signature;
        this.myTypeArgs = typeArgs;
    }

    @Nullable
    public GrClosableBlock getClosure() {
        return this.myClosure;
    }

    private void setClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            GrClosureType.$$$reportNull$$$0(8);
        }
        this.myClosure = closure;
    }

    public int getParameterCount() {
        PsiClass resolved = this.resolve();
        return resolved != null && resolved.getTypeParameters().length == 1 ? 1 : 0;
    }

    @NotNull
    public PsiType[] getParameters() {
        if (ourForbidClosureInference) {
            throw new IllegalStateException();
        }
        if (this.myTypeArgs == null) {
            this.myTypeArgs = this.inferParameters();
        }
        if (this.myTypeArgs == null) {
            GrClosureType.$$$reportNull$$$0(9);
        }
        return this.myTypeArgs;
    }

    @NotNull
    public PsiType[] inferParameters() {
        PsiClass psiClass = this.resolve();
        if (psiClass != null && psiClass.getTypeParameters().length == 1) {
            PsiType type = GrClosureSignatureUtil.getReturnType(this.mySignature);
            if (type == PsiType.NULL || type == null) {
                PsiType[] psiTypeArray = new PsiType[]{null};
                if (psiTypeArray == null) {
                    GrClosureType.$$$reportNull$$$0(10);
                }
                return psiTypeArray;
            }
            PsiType[] psiTypeArray = new PsiType[]{TypesUtil.boxPrimitiveType(type, this.getPsiManager(), this.getResolveScope(), true)};
            if (psiTypeArray == null) {
                GrClosureType.$$$reportNull$$$0(11);
            }
            return psiTypeArray;
        }
        if (PsiType.EMPTY_ARRAY == null) {
            GrClosureType.$$$reportNull$$$0(12);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        if ("groovy.lang.Closure" == null) {
            GrClosureType.$$$reportNull$$$0(13);
        }
        return "groovy.lang.Closure";
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        if (this.myTypeArgs != null && this.myTypeArgs.length == 0) {
            GrClosureType grClosureType = this;
            if (grClosureType == null) {
                GrClosureType.$$$reportNull$$$0(14);
            }
            return grClosureType;
        }
        GrClosureType grClosureType = new GrClosureType(this.getLanguageLevel(), this.getResolveScope(), this.myFacade, this.mySignature, false);
        if (grClosureType == null) {
            GrClosureType.$$$reportNull$$$0(15);
        }
        return grClosureType;
    }

    public boolean isValid() {
        return this.mySignature.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureType) {
            return Comparing.equal((Object)this.mySignature, (Object)((GrClosureType)((Object)obj)).mySignature);
        }
        return super.equals(obj);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(16);
        }
        GrClosureType grClosureType = new GrClosureType(languageLevel, this.myScope, this.myFacade, this.mySignature, this.myTypeArgs);
        if (grClosureType == null) {
            GrClosureType.$$$reportNull$$$0(17);
        }
        return grClosureType;
    }

    @NotNull
    public static GrClosureType create(@NotNull Iterable<? extends GroovyResolveResult> results, @NotNull GroovyPsiElement context) {
        if (results == null) {
            GrClosureType.$$$reportNull$$$0(18);
        }
        if (context == null) {
            GrClosureType.$$$reportNull$$$0(19);
        }
        ArrayList<GrClosureSignature> signatures = new ArrayList<GrClosureSignature>();
        for (GroovyResolveResult groovyResolveResult : results) {
            if (!(groovyResolveResult.getElement() instanceof PsiMethod)) continue;
            signatures.add(GrClosureSignatureUtil.createSignature((PsiMethod)groovyResolveResult.getElement(), groovyResolveResult.getSubstitutor()));
        }
        GlobalSearchScope resolveScope = context.getResolveScope();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)context.getProject());
        if (signatures.size() == 1) {
            GrClosureType grClosureType = GrClosureType.create((GrSignature)signatures.get(0), resolveScope, javaPsiFacade, LanguageLevel.JDK_1_5, true);
            if (grClosureType == null) {
                GrClosureType.$$$reportNull$$$0(20);
            }
            return grClosureType;
        }
        GrClosureType grClosureType = GrClosureType.create(GrClosureSignatureUtil.createMultiSignature(signatures.toArray(GrClosureSignature.EMPTY_ARRAY)), resolveScope, javaPsiFacade, LanguageLevel.JDK_1_5, true);
        if (grClosureType == null) {
            GrClosureType.$$$reportNull$$$0(21);
        }
        return grClosureType;
    }

    public static GrClosureType create(@NotNull GrClosableBlock closure, boolean shouldInferTypeParameters) {
        if (closure == null) {
            GrClosureType.$$$reportNull$$$0(22);
        }
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(closure);
        GlobalSearchScope resolveScope = closure.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)closure.getProject());
        GrClosureType type = GrClosureType.create(signature, resolveScope, facade, LanguageLevel.JDK_1_5, shouldInferTypeParameters);
        type.setClosure(closure);
        return type;
    }

    public static GrClosureType create(@NotNull GrSignature signature, GlobalSearchScope scope, JavaPsiFacade facade, @NotNull LanguageLevel languageLevel, boolean shouldInferTypeParameters) {
        if (signature == null) {
            GrClosureType.$$$reportNull$$$0(23);
        }
        if (languageLevel == null) {
            GrClosureType.$$$reportNull$$$0(24);
        }
        return new GrClosureType(languageLevel, scope, facade, signature, shouldInferTypeParameters);
    }

    @Nullable
    public PsiType curry(@NotNull PsiType[] args, int position, @NotNull GroovyPsiElement context) {
        GrSignature newSignature;
        if (args == null) {
            GrClosureType.$$$reportNull$$$0(25);
        }
        if (context == null) {
            GrClosureType.$$$reportNull$$$0(26);
        }
        if ((newSignature = this.mySignature.curry(args, position, context)) == null) {
            return null;
        }
        return new GrClosureType(this.myLanguageLevel, this.myScope, this.myFacade, newSignature, this.myTypeArgs);
    }

    @NotNull
    public GrSignature getSignature() {
        GrSignature grSignature = this.mySignature;
        if (grSignature == null) {
            GrClosureType.$$$reportNull$$$0(27);
        }
        return grSignature;
    }

    public String toString() {
        return "PsiType: Closure<*>";
    }

    public static void forbidClosureInference(@NotNull Runnable runnable) {
        if (runnable == null) {
            GrClosureType.$$$reportNull$$$0(28);
        }
        ourForbidClosureInference = true;
        try {
            runnable.run();
        }
        finally {
            ourForbidClosureInference = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureSignature";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClosureType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "inferParameters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaClassName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setClosure";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 27: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "curry";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "forbidClosureInference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

