/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrMethodSignatureImpl
implements GrClosureSignature {
    private final PsiMethod myMethod;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myEraseParameterTypes;

    GrMethodSignatureImpl(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean eraseParameterTypes) {
        if (method == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(1);
        }
        this.myMethod = method;
        this.mySubstitutor = substitutor;
        this.myEraseParameterTypes = eraseParameterTypes;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(2);
        }
        return psiSubstitutor;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        GrClosureParameter[] grClosureParameterArray = (GrClosureParameter[])ContainerUtil.map((Object[])this.myMethod.getParameterList().getParameters(), parameter -> new GrClosureParameterImpl((PsiParameter)parameter, this.mySubstitutor, this.myEraseParameterTypes), (Object[])GrClosureParameter.EMPTY_ARRAY);
        if (grClosureParameterArray == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(3);
        }
        return grClosureParameterArray;
    }

    @Override
    public int getParameterCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Override
    public boolean isVarargs() {
        return GrClosureSignatureUtil.isVarArgsImpl(this.getParameters());
    }

    @Override
    public PsiType getReturnType() {
        PsiType type = this.getReturnTypeInner();
        return this.myEraseParameterTypes ? TypeConversionUtil.erasure((PsiType)type) : type;
    }

    private PsiType getReturnTypeInner() {
        PsiSubstitutor substitutor = this.getSubstitutor();
        if (this.myMethod.isConstructor()) {
            PsiClass clazz = this.myMethod.getContainingClass();
            if (clazz == null) {
                return null;
            }
            return GroovyPsiElementFactory.getInstance(this.myMethod.getProject()).createType(clazz, substitutor);
        }
        return substitutor.substitute(PsiUtil.getSmartReturnType(this.myMethod));
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myMethod.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    @Nullable
    public GrSignature curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        if (args == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(5);
        }
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public void accept(@NotNull GrSignatureVisitor visitor2) {
        if (visitor2 == null) {
            GrMethodSignatureImpl.$$$reportNull$$$0(6);
        }
        visitor2.visitClosureSignature(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "curry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

