/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators;

import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrBinaryExpressionUtil {
    private static final int[] RANKS = new int[]{4, 5, 6, 7, 9};

    public static PsiType getDefaultNumericResultType(PsiType ltype, PsiType rtype, GrOperatorExpression e) {
        int rRank;
        int lRank = TypeConstants.getTypeRank(ltype);
        int resultRank = GrBinaryExpressionUtil.getResultTypeRank(lRank, rRank = TypeConstants.getTypeRank(rtype));
        String fqn = TypeConstants.getTypeFqn(resultRank);
        return fqn == null ? null : TypesUtil.createTypeByFQClassName(fqn, e);
    }

    private static int getResultTypeRank(int lRank, int rRank) {
        for (int rank : RANKS) {
            if (lRank > rank || rRank > rank) continue;
            return rank;
        }
        return 0;
    }

    public static PsiType createDouble(GrOperatorExpression e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Double", e);
    }

    public static PsiType createLong(GrOperatorExpression e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Long", e);
    }

    public static PsiType createInteger(GrOperatorExpression e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Integer", e);
    }

    public static PsiType createBigDecimal(GrOperatorExpression e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.math.BigDecimal", e);
    }

    public static boolean isBigDecimal(PsiType lType, PsiType rType) {
        return lType.equalsToText("java.math.BigDecimal") || rType.equalsToText("java.math.BigDecimal");
    }

    public static boolean isFloatOrDouble(PsiType ltype, PsiType rtype) {
        return ltype.equalsToText("java.lang.Double") || rtype.equalsToText("java.lang.Double") || ltype.equalsToText("java.lang.Float") || rtype.equalsToText("java.lang.Float");
    }

    public static boolean isLong(PsiType ltype, PsiType rtype) {
        return ltype.equalsToText("java.lang.Long") || rtype.equalsToText("java.lang.Long");
    }

    public static PsiType getTypeByFQName(String fqn, GrOperatorExpression e) {
        return TypesUtil.createTypeByFQClassName(fqn, e);
    }
}

