/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;

public class GrFieldElementType
extends GrStubElementType<GrFieldStub, GrField> {
    public GrFieldElementType(String debugName) {
        super(debugName);
    }

    public GrField createPsi(@NotNull GrFieldStub stub) {
        if (stub == null) {
            GrFieldElementType.$$$reportNull$$$0(0);
        }
        return new GrFieldImpl(stub);
    }

    @NotNull
    public GrFieldStub createStub(@NotNull GrField psi, StubElement parentStub) {
        if (psi == null) {
            GrFieldElementType.$$$reportNull$$$0(1);
        }
        String[] annNames = GrStubUtils.getAnnotationNames((PsiModifierListOwner)psi);
        Set<Object> namedParameters = Collections.emptySet();
        if (psi instanceof GrFieldImpl) {
            namedParameters = psi.getNamedParameters().keySet();
        }
        GrFieldStub grFieldStub = new GrFieldStub(parentStub, StringRef.fromString((String)psi.getName()), annNames, namedParameters.toArray(ArrayUtil.EMPTY_STRING_ARRAY), GroovyElementTypes.FIELD, GrFieldStub.buildFlags(psi), GrStubUtils.getTypeText(psi.getTypeElementGroovy()));
        if (grFieldStub == null) {
            GrFieldElementType.$$$reportNull$$$0(2);
        }
        return grFieldStub;
    }

    public void serialize(@NotNull GrFieldStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrFieldElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            GrFieldElementType.$$$reportNull$$$0(4);
        }
        GrFieldElementType.serializeFieldStub(stub, dataStream);
    }

    @NotNull
    public GrFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrFieldElementType.$$$reportNull$$$0(5);
        }
        GrFieldStub grFieldStub = GrFieldElementType.deserializeFieldStub(dataStream, parentStub);
        if (grFieldStub == null) {
            GrFieldElementType.$$$reportNull$$$0(6);
        }
        return grFieldStub;
    }

    @Override
    public void indexStub(@NotNull GrFieldStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrFieldElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            GrFieldElementType.$$$reportNull$$$0(8);
        }
        GrFieldElementType.indexFieldStub(stub, sink);
    }

    static void serializeFieldStub(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeStringArray(dataStream, stub.getNamedParameters());
        dataStream.writeByte((int)stub.getFlags());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
    }

    static GrFieldStub deserializeFieldStub(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        String[] annNames = GrStubUtils.readStringArray(dataStream);
        String[] namedParameters = GrStubUtils.readStringArray(dataStream);
        byte flags = dataStream.readByte();
        String typeText = GrStubUtils.readNullableString(dataStream);
        return new GrFieldStub(parentStub, ref, annNames, namedParameters, GrFieldStub.isEnumConstant(flags) ? GroovyElementTypes.ENUM_CONSTANT : GroovyElementTypes.FIELD, flags, typeText);
    }

    static void indexFieldStub(GrFieldStub stub, IndexSink sink) {
        String name = stub.getName();
        sink.occurrence(GrFieldNameIndex.KEY, (Object)name);
        if (GrStubUtils.isGroovyStaticMemberStub(stub)) {
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)GrStubUtils.getShortTypeText(stub.getTypeText()));
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

