/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class InitializerBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String INITIALIZER_STRATEGY_NAME = "InitializerStrategy";
    public static final String SET_FQN = "groovy.transform.builder.InitializerStrategy.SET";
    public static final String UNSET_FQN = "groovy.transform.builder.InitializerStrategy.UNSET";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            InitializerBuilderStrategySupport.$$$reportNull$$$0(0);
        }
        new InitializerBuilderStrategyHandler(context).doProcess();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport", "applyTransformation"));
    }

    private static class InitializerTypeParameter
    extends LightTypeParameterBuilder {
        InitializerTypeParameter(PsiTypeParameterListOwner owner, int index) {
            super("T" + index, owner, index);
        }
    }

    private static class InitializerBuilderStrategyHandler {
        @NotNull
        private final TransformationContext myContext;
        @NotNull
        private final GrTypeDefinition myContainingClass;
        @NotNull
        private final PsiElementFactory myElementFactory;

        private InitializerBuilderStrategyHandler(@NotNull TransformationContext context) {
            if (context == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            this.myContainingClass = context.getCodeClass();
            this.myElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.myContainingClass.getProject());
        }

        public void doProcess() {
            this.processTypeDefinition();
            this.processConstructors();
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, InitializerBuilderStrategySupport.INITIALIZER_STRATEGY_NAME)) {
                return;
            }
            boolean includeSuper = BuilderAnnotationContributor.isIncludeSuperProperties(builderAnno);
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, (PsiVariable[])BuilderAnnotationContributor.getFields(this.myContext, includeSuper));
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myContext.addMethod((PsiMethod)this.createBuilderConstructor(this.myContainingClass, (PsiClass)builderClass, builderAnno));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull PsiVariable[] setters) {
            int i;
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(1);
            }
            if (setters == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(2);
            }
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (i = 0; i < setters.length; ++i) {
                builderClass.getTypeParameterList().addParameter((PsiTypeParameter)new InitializerTypeParameter((PsiTypeParameterListOwner)builderClass, i));
            }
            for (i = 0; i < setters.length; ++i) {
                builderClass.addMethod((PsiMethod)this.createFieldSetter(builderClass, setters[i], annotation, i));
            }
            LightPsiClassBuilder lightPsiClassBuilder = builderClass.addMethod((PsiMethod)this.createBuildMethod(annotation, (PsiClass)builderClass));
            if (lightPsiClassBuilder == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(3);
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightMethodBuilder createFieldSetter(@NotNull LightPsiClassBuilder builderClass, @NotNull PsiVariable field, @NotNull PsiAnnotation annotation, int currentField) {
            if (builderClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(4);
            }
            if (field == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(5);
            }
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(6);
            }
            String name = Objects.requireNonNull(field.getName());
            LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(builderClass.getTypeParameters()[currentField], (PsiType)this.myElementFactory.createTypeByFQClassName(InitializerBuilderStrategySupport.SET_FQN, annotation.getResolveScope()));
            fieldSetter.addModifier("public");
            fieldSetter.addParameter(name, field.getType());
            fieldSetter.setContainingClass((PsiClass)builderClass);
            fieldSetter.setMethodReturnType((PsiType)this.myElementFactory.createType((PsiClass)builderClass, substitutor));
            fieldSetter.setNavigationElement((PsiElement)field);
            fieldSetter.setOriginInfo("via @Builder");
            LightMethodBuilder lightMethodBuilder = fieldSetter;
            if (lightMethodBuilder == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(7);
            }
            return lightMethodBuilder;
        }

        private LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiClass builderClass) {
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(8);
            }
            if (builderClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(9);
            }
            LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), builderClass.getLanguage(), InitializerBuilderStrategyHandler.getBuildMethodName(annotation));
            buildMethod.addModifier("static");
            buildMethod.setContainingClass(builderClass);
            buildMethod.setOriginInfo("via @Builder");
            buildMethod.setNavigationElement((PsiElement)annotation);
            buildMethod.setMethodReturnType(this.createAllSetUnsetType(builderClass, false));
            return buildMethod;
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(10);
            }
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(11);
            }
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.myContext.getManager(), InitializerBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType(this.createAllSetUnsetType(builderClass, false));
            LightMethodBuilder lightMethodBuilder = builderMethod;
            if (lightMethodBuilder == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(12);
            }
            return lightMethodBuilder;
        }

        @NotNull
        private LightMethodBuilder createBuilderConstructor(@NotNull PsiClass constructedClass, @NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (constructedClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(13);
            }
            if (builderClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(14);
            }
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(15);
            }
            LightMethodBuilder constructor = new LightMethodBuilder(constructedClass, constructedClass.getLanguage()).addParameter("builder", this.createAllSetUnsetType(builderClass, true)).setConstructor(true);
            constructor.setNavigationElement((PsiElement)annotation);
            constructor.setOriginInfo("via @Builder");
            LightMethodBuilder lightMethodBuilder = constructor;
            if (lightMethodBuilder == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(16);
            }
            return lightMethodBuilder;
        }

        private void processConstructors() {
            for (GrMethod method : this.myContainingClass.getCodeMethods()) {
                PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
                if (!BuilderAnnotationContributor.isApplicable(annotation, InitializerBuilderStrategySupport.INITIALIZER_STRATEGY_NAME)) {
                    return;
                }
                if (!method.isConstructor()) continue;
                this.processConstructor(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, @NotNull PsiAnnotation annotation) {
            if (method == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(17);
            }
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(18);
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addMethod((PsiMethod)this.createBuilderConstructor(this.myContainingClass, (PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            String builderMethodName;
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(19);
            }
            String string = StringUtil.isEmpty((String)(builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName"))) ? "createInitializer" : builderMethodName;
            if (string == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(20);
            }
            return string;
        }

        @NotNull
        private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
            String builderMethodName;
            if (annotation == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(21);
            }
            String string = StringUtil.isEmpty((String)(builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName"))) ? "create" : builderMethodName;
            if (string == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(22);
            }
            return string;
        }

        @NotNull
        private PsiType createAllSetUnsetType(@NotNull PsiClass builderClass, boolean setUnset) {
            if (builderClass == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(23);
            }
            PsiClassType type = this.myElementFactory.createTypeByFQClassName(setUnset ? InitializerBuilderStrategySupport.SET_FQN : InitializerBuilderStrategySupport.UNSET_FQN, builderClass.getResolveScope());
            PsiType[] mappings = PsiType.createArray((int)builderClass.getTypeParameters().length);
            for (int i = 0; i < mappings.length; ++i) {
                mappings[i] = type;
            }
            PsiClassType psiClassType = this.myElementFactory.createType(builderClass, mappings);
            if (psiClassType == null) {
                InitializerBuilderStrategyHandler.$$$reportNull$$$0(24);
            }
            return psiClassType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: 
                case 12: 
                case 16: 
                case 20: 
                case 22: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: 
                case 12: 
                case 16: 
                case 20: 
                case 22: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 6: 
                case 8: 
                case 11: 
                case 15: 
                case 18: 
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setters";
                    break;
                }
                case 3: 
                case 7: 
                case 12: 
                case 16: 
                case 20: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 14: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builderClass";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructedClass";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilderClass";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldSetter";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilderMethod";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBuilderConstructor";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilderMethodName";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildMethodName";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAllSetUnsetType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilderClass";
                    break;
                }
                case 3: 
                case 7: 
                case 12: 
                case 16: 
                case 20: 
                case 22: 
                case 24: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldSetter";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuildMethod";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilderMethod";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuilderConstructor";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "processConstructor";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getBuilderMethodName";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getBuildMethodName";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "createAllSetUnsetType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 12: 
                case 16: 
                case 20: 
                case 22: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

