/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypeConstraint;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ReferenceExpressionConstraint;", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "callRef", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "leftType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lcom/intellij/psi/PsiType;)V", "apply", "", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "cache", "", "reduce", "session", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceSession;", "constraints", "", "intellij.groovy.psi"})
public final class ReferenceExpressionConstraint
implements ConstraintFormula {
    private final GrReferenceExpression callRef;
    private final PsiType leftType;

    public boolean reduce(@NotNull InferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        block8: {
            PsiType psiType;
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
            InferenceSession inferenceSession = session;
            if (!(inferenceSession instanceof GroovyInferenceSession)) {
                inferenceSession = null;
            }
            if ((GroovyInferenceSession)inferenceSession == null) {
                return true;
            }
            GroovyResolveResult groovyResolveResult = this.callRef.advancedResolve();
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"callRef.advancedResolve()");
            GroovyResolveResult resolved = groovyResolveResult;
            GroovyResolveResult groovyResolveResult2 = resolved;
            if (!(groovyResolveResult2 instanceof GroovyMethodResult)) {
                groovyResolveResult2 = null;
            }
            if ((GroovyMethodResult)groovyResolveResult2 == null) {
                return true;
            }
            MethodCandidate methodCandidate2 = ((GroovyMethodResult)resolved).getCandidate();
            if (methodCandidate2 != null) {
                MethodCandidate methodCandidate3;
                MethodCandidate it = methodCandidate3 = methodCandidate2;
                PsiTypeParameter[] psiTypeParameterArray = it.getMethod().getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"it.method.typeParameters");
                PsiTypeParameter[] typeParameters = psiTypeParameterArray;
                GroovyInferenceSession nestedSession = new GroovyInferenceSession(typeParameters, it.getSiteSubstitutor(), this.callRef, CollectionsKt.emptyList(), ((GroovyInferenceSession)session).getSkipClosureBlock());
                Map<GrReferenceExpression, GroovyInferenceSession> map2 = ((GroovyInferenceSession)session).getMyNestedSessions();
                GrReferenceExpression grReferenceExpression = this.callRef;
                GroovyInferenceSession groovyInferenceSession = nestedSession;
                map2.put(grReferenceExpression, groovyInferenceSession);
                nestedSession.propagateVariables(((GroovyInferenceSession)session).getInferenceVariables(), ((GroovyInferenceSession)session).getRestoreNameSubstitution());
                MethodCandidate methodCandidate4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)methodCandidate4, (String)"it");
                nestedSession.addConstraint(new MethodCallConstraint(this.callRef, methodCandidate4));
                nestedSession.repeatInferencePhases();
                PsiType returnType = ((GroovyInferenceSession)session).getSiteSubstitutor().substitute(PsiUtil.getSmartReturnType(it.getMethod()));
                PsiType substitutedLeft = ((GroovyInferenceSession)session).getSiteSubstitutor().substitute(session.substituteWithInferenceVariables(this.leftType));
                if (returnType != null && Intrinsics.areEqual((Object)PsiType.VOID, (Object)returnType) ^ true && this.leftType != null) {
                    PsiType psiType2 = substitutedLeft;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"substitutedLeft");
                    nestedSession.addConstraint(new TypeConstraint(psiType2, returnType, this.callRef));
                    nestedSession.repeatInferencePhases();
                }
                session.propagateVariables(nestedSession.getInferenceVariables(), nestedSession.getRestoreNameSubstitution());
                InferenceIncorporationPhase inferenceIncorporationPhase = nestedSession.myIncorporationPhase;
                Intrinsics.checkExpressionValueIsNotNull((Object)inferenceIncorporationPhase, (String)"nestedSession.myIncorporationPhase");
                for (Pair pair : inferenceIncorporationPhase.getCaptures()) {
                    session.myIncorporationPhase.addCapture((InferenceVariable[])pair.first, (PsiClassType)pair.second);
                }
                return true;
            }
            if (this.leftType == null) {
                return true;
            }
            PsiType psiType3 = this.callRef.getType();
            if (psiType3 == null) break block8;
            PsiType it = psiType = psiType3;
            constraints.add((ConstraintFormula)new TypeCompatibilityConstraint(this.leftType, it));
        }
        return true;
    }

    public void apply(@NotNull PsiSubstitutor substitutor, boolean cache2) {
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
    }

    public ReferenceExpressionConstraint(@NotNull GrReferenceExpression callRef, @Nullable PsiType leftType) {
        Intrinsics.checkParameterIsNotNull((Object)callRef, (String)"callRef");
        this.callRef = callRef;
        this.leftType = leftType;
    }
}

