/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.structure;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Selection {
    private Set<Element> mSelectedWidgets = new HashSet<Element>();
    private ArrayList<ConstraintWidget> mModifiedWidgets = new ArrayList();
    private ArrayList<SelectionListener> mSelectionListeners = new ArrayList();
    private ConstraintAnchor mSelectedAnchor = null;
    private ConstraintAnchor mConnectionCandidateAnchor = null;
    private ConstraintAnchor mLastConnectedAnchor = null;
    private ConstraintAnchor mSelectedAnchorInitialTarget;
    private ResizeHandle mSelectedResizeHandle;
    Guideline mSelectedGuideline;
    public static final int DIRECTION_UNLOCKED = 0;
    public static final int DIRECTION_LOCKED_X = 1;
    public static final int DIRECTION_LOCKED_Y = 2;
    private Element mBounds;
    private Rectangle mOriginalWidgetBounds = new Rectangle();
    private SelectionListener mContinuousListener;

    public Selection(SelectionListener listener) {
        if (listener != null) {
            this.mSelectionListeners.add(listener);
        }
    }

    public void clear() {
        this.mSelectedWidgets.clear();
        this.mModifiedWidgets.clear();
        this.selectionHasChanged();
    }

    public void clearModifiedWidgets() {
        this.mModifiedWidgets.clear();
    }

    public boolean isEmpty() {
        return this.mSelectedWidgets.isEmpty();
    }

    public boolean hasSingleElement() {
        return this.mSelectedWidgets.size() == 1;
    }

    public Element getFirstElement() {
        if (this.mSelectedWidgets.isEmpty()) {
            return null;
        }
        return this.mSelectedWidgets.iterator().next();
    }

    public Collection<Element> getElements() {
        return this.mSelectedWidgets;
    }

    public ArrayList<ConstraintWidget> getModifiedWidgets() {
        return this.mModifiedWidgets;
    }

    public void addModifiedWidget(ConstraintWidget widget) {
        if (this.mModifiedWidgets.contains(widget)) {
            return;
        }
        this.mModifiedWidgets.add(widget);
    }

    public int size() {
        return this.mSelectedWidgets.size();
    }

    public boolean contains(ConstraintWidget widget) {
        for (Element w : this.mSelectedWidgets) {
            if (w.widget != widget) continue;
            return true;
        }
        return false;
    }

    public void add(ConstraintWidget widget) {
        this.mSelectedWidgets.add(new Element(widget));
        this.selectionHasChanged();
    }

    public void silentAdd(ConstraintWidget widget) {
        this.mSelectedWidgets.add(new Element(widget));
    }

    public void silentClear() {
        this.mSelectedWidgets.clear();
        this.mModifiedWidgets.clear();
    }

    public void remove(ConstraintWidget widget) {
        Element toUnselect = null;
        for (Element selection : this.mSelectedWidgets) {
            if (selection.widget != widget) continue;
            toUnselect = selection;
            break;
        }
        if (toUnselect != null) {
            this.mSelectedWidgets.remove(toUnselect);
        }
        this.selectionHasChanged();
    }

    public Element get(ConstraintWidget widget) {
        for (Element element : this.mSelectedWidgets) {
            if (element.widget != widget) continue;
            return element;
        }
        return null;
    }

    public void updatePosition() {
        for (Element selection : this.mSelectedWidgets) {
            selection.updatePosition();
        }
    }

    public ArrayList<ConstraintWidget> getWidgets() {
        ArrayList<ConstraintWidget> widgets = new ArrayList<ConstraintWidget>();
        for (Element selection : this.mSelectedWidgets) {
            widgets.add(selection.widget);
        }
        return widgets;
    }

    public void selectionHasChanged() {
        if (this.mContinuousListener != null) {
            this.mContinuousListener.onSelectionChanged(this);
        }
        for (SelectionListener selectionListener : this.mSelectionListeners) {
            selectionListener.onSelectionChanged(this);
        }
    }

    public void setContinuousListener(SelectionListener continuousListener) {
        this.mContinuousListener = continuousListener;
    }

    public void fireContinuousChange() {
        if (this.mContinuousListener != null) {
            this.mContinuousListener.onSelectionChanged(this);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListeners.add(selectionListener);
    }

    public ConstraintAnchor getConnectionCandidateAnchor() {
        return this.mConnectionCandidateAnchor;
    }

    public void setConnectionCandidateAnchor(ConstraintAnchor anchor) {
        this.mConnectionCandidateAnchor = anchor;
    }

    public void setLastConnectedAnchor(ConstraintAnchor lastConnectedAnchor) {
        this.mLastConnectedAnchor = lastConnectedAnchor;
    }

    public ConstraintAnchor getLastConnectedAnchor() {
        return this.mLastConnectedAnchor;
    }

    public ConstraintAnchor getSelectedAnchor() {
        return this.mSelectedAnchor;
    }

    public void setSelectedAnchor(ConstraintAnchor anchor) {
        this.mSelectedAnchor = anchor;
    }

    public ConstraintAnchor getSelectedAnchorInitialTarget() {
        return this.mSelectedAnchorInitialTarget;
    }

    public void setSelectedAnchorInitialTarget(ConstraintAnchor anchor) {
        this.mSelectedAnchorInitialTarget = anchor;
    }

    public ResizeHandle getSelectedResizeHandle() {
        return this.mSelectedResizeHandle;
    }

    public void setSelectedResizeHandle(ResizeHandle handle) {
        this.mSelectedResizeHandle = handle;
        if (this.mSelectedResizeHandle != null) {
            ConstraintWidget widget = this.mSelectedResizeHandle.getOwner();
            this.mOriginalWidgetBounds.setBounds(widget.getDrawX(), widget.getDrawY(), widget.getWidth(), widget.getHeight());
        } else {
            this.mOriginalWidgetBounds.setBounds(0, 0, 0, 0);
        }
    }

    public Rectangle getOriginalWidgetBounds() {
        return this.mOriginalWidgetBounds;
    }

    public Guideline getSelectedGuideline() {
        return this.mSelectedGuideline;
    }

    public void setSelectedGuideline(Guideline guideline) {
        this.mSelectedGuideline = guideline;
    }

    public void clearBounds() {
        this.mBounds = null;
    }

    public Element getSelectionBounds() {
        return this.mBounds;
    }

    public void createBounds() {
        if (this.isEmpty() || this.hasSingleElement()) {
            this.mBounds = null;
            return;
        }
        int l = Integer.MAX_VALUE;
        int t = Integer.MAX_VALUE;
        int r = 0;
        int b = 0;
        for (Element selection : this.getElements()) {
            ConstraintWidget w = selection.widget;
            l = Math.min(w.getDrawX(), l);
            t = Math.min(w.getDrawY(), t);
            r = Math.max(w.getDrawRight(), r);
            b = Math.max(w.getDrawBottom(), b);
        }
        ConstraintWidget bounds = new ConstraintWidget(l, t, r - l, b - t);
        bounds.setCompanionWidget(WidgetCompanion.create(bounds));
        this.mBounds = new Element(bounds);
        this.updateOriginFromBounds();
    }

    public void updatePositionsFromBounds() {
        if (this.mBounds == null) {
            return;
        }
        int x = this.mBounds.widget.getDrawX();
        int y = this.mBounds.widget.getDrawY();
        for (Element selection : this.getElements()) {
            selection.widget.setDrawX(x + selection.origin.x);
            selection.widget.setDrawY(y + selection.origin.y);
            this.addModifiedWidget(selection.widget);
        }
    }

    private void updateOriginFromBounds() {
        if (this.mBounds == null) {
            return;
        }
        int x = this.mBounds.origin.x;
        int y = this.mBounds.origin.y;
        for (Element selection : this.getElements()) {
            selection.origin.x = selection.widget.getDrawX() - x;
            selection.origin.y = selection.widget.getDrawY() - y;
        }
    }

    public static class Element {
        public ConstraintWidget widget;
        public Point origin = new Point();
        public int directionLocked = 0;

        public Element(ConstraintWidget widget) {
            this.widget = widget;
            this.origin.setLocation(widget.getDrawX(), widget.getDrawY());
        }

        public void updatePosition() {
            this.origin.setLocation(this.widget.getDrawX(), this.widget.getDrawY());
        }
    }

    public static interface SelectionListener {
        public void onSelectionChanged(Selection var1);
    }
}

