/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.client.methods;

import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.header.DepthHeader;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportInfo;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.IOException;

public class ReportMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(ReportMethod.class);
    private final boolean isDeep;

    public ReportMethod(String uri, ReportInfo reportInfo) throws IOException {
        super(uri);
        DepthHeader dh = new DepthHeader(reportInfo.getDepth());
        this.isDeep = reportInfo.getDepth() > 0;
        this.setRequestHeader(dh);
        this.setRequestBody(reportInfo);
    }

    public String getName() {
        return "REPORT";
    }

    protected boolean isSuccess(int statusCode) {
        if (this.isDeep) {
            return statusCode == 207;
        }
        return statusCode == 200 || statusCode == 207;
    }
}

