/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.CachingExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradleAutoImportAware;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleManager
implements ExternalSystemConfigurableAware,
ExternalSystemUiAware,
ExternalSystemAutoImportAware,
StartupActivity,
ExternalSystemManager<GradleProjectSettings, GradleSettingsListener, GradleSettings, GradleLocalSettings, GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleManager.class);
    @NotNull
    private final ExternalSystemAutoImportAware myAutoImportDelegate;
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    @NotNull
    private static final NotNullLazyValue<List<GradleProjectResolverExtension>> RESOLVER_EXTENSIONS = new AtomicNotNullLazyValue<List<GradleProjectResolverExtension>>(){

        @NotNull
        protected List<GradleProjectResolverExtension> compute() {
            ExtensionPoint point;
            ArrayList result = ContainerUtilRt.newArrayList();
            boolean isJavaIde = ExternalSystemApiUtil.isJavaCompatibleIde();
            if (!isJavaIde && (point = Extensions.getRootArea().getExtensionPoint(GradleProjectResolverExtension.EP_NAME)) instanceof ExtensionPointImpl) {
                ((ExtensionPointImpl)point).removeUnloadableExtensions();
            }
            Set javaIdeDependentExtensions = ContainerUtil.set((Object[])new String[]{"org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtension", "org.jetbrains.kotlin.kapt.idea.KaptProjectResolverExtension", "org.jetbrains.kotlin.allopen.ide.AllOpenProjectResolverExtension", "org.jetbrains.kotlin.noarg.ide.NoArgProjectResolverExtension", "org.jetbrains.kotlin.samWithReceiver.ide.SamWithReceiverProjectResolverExtension"});
            Predicate<GradleProjectResolverExtension> extensionsFilter = ext -> isJavaIde || !javaIdeDependentExtensions.contains(ext.getClass().getName());
            Arrays.stream(GradleProjectResolverExtension.EP_NAME.getExtensions()).filter(extensionsFilter).forEach(result::add);
            ExternalSystemApiUtil.orderAwareSort((List)result);
            ArrayList arrayList = result;
            if (arrayList == null) {
                1.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/GradleManager$1", "compute"));
        }
    };

    public GradleManager(@NotNull GradleInstallationManager manager) {
        if (manager == null) {
            GradleManager.$$$reportNull$$$0(0);
        }
        this.myAutoImportDelegate = new CachingExternalSystemAutoImportAware((ExternalSystemAutoImportAware)new GradleAutoImportAware());
        this.myInstallationManager = manager;
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleManager.$$$reportNull$$$0(1);
        }
        return projectSystemId;
    }

    @NotNull
    public Function<Project, GradleSettings> getSettingsProvider() {
        Function function = project -> GradleSettings.getInstance(project);
        if (function == null) {
            GradleManager.$$$reportNull$$$0(2);
        }
        return function;
    }

    @NotNull
    public Function<Project, GradleLocalSettings> getLocalSettingsProvider() {
        Function function = project -> GradleLocalSettings.getInstance(project);
        if (function == null) {
            GradleManager.$$$reportNull$$$0(3);
        }
        return function;
    }

    @NotNull
    public Function<Pair<Project, String>, GradleExecutionSettings> getExecutionSettingsProvider() {
        Function function = pair -> {
            String javaHome;
            GradleProjectSettings projectLevelSettings;
            Project project = (Project)pair.first;
            GradleSettings settings = GradleSettings.getInstance(project);
            File gradleHome = this.myInstallationManager.getGradleHome(project, (String)pair.second);
            String localGradlePath = null;
            if (gradleHome != null) {
                try {
                    localGradlePath = gradleHome.getCanonicalPath();
                }
                catch (IOException e) {
                    localGradlePath = gradleHome.getAbsolutePath();
                }
            }
            DistributionType distributionType = (projectLevelSettings = (GradleProjectSettings)settings.getLinkedProjectSettings((String)pair.second)) == null ? (GradleUtil.isGradleDefaultWrapperFilesExist((String)pair.second) ? DistributionType.DEFAULT_WRAPPED : DistributionType.BUNDLED) : (projectLevelSettings.getDistributionType() == null ? DistributionType.LOCAL : projectLevelSettings.getDistributionType());
            GradleExecutionSettings result = new GradleExecutionSettings(localGradlePath, settings.getServiceDirectoryPath(), distributionType, settings.getGradleVmOptions(), settings.isOfflineWork());
            for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
                result.addResolverExtensionClass(ClassHolder.from(extension.getClass()));
            }
            String rootProjectPath = projectLevelSettings != null ? projectLevelSettings.getExternalProjectPath() : (String)pair.second;
            Sdk gradleJdk = this.myInstallationManager.getGradleJdk(project, rootProjectPath);
            String string = javaHome = gradleJdk != null ? gradleJdk.getHomePath() : null;
            if (!StringUtil.isEmpty((String)javaHome)) {
                LOG.info("Instructing gradle to use java from " + javaHome);
            }
            result.setJavaHome(javaHome);
            String ideProjectPath = project.getBasePath() == null || project.getProjectFilePath() != null && StringUtil.endsWith((CharSequence)project.getProjectFilePath(), (CharSequence)".ipr") ? rootProjectPath : project.getBasePath() + "/.idea/modules";
            result.setIdeProjectPath(ideProjectPath);
            if (projectLevelSettings != null) {
                result.setResolveModulePerSourceSet(projectLevelSettings.isResolveModulePerSourceSet());
                result.setUseQualifiedModuleNames(projectLevelSettings.isUseQualifiedModuleNames());
            }
            GradleManager.configureExecutionWorkspace(projectLevelSettings, settings, result, project, (String)pair.second);
            return result;
        };
        if (function == null) {
            GradleManager.$$$reportNull$$$0(4);
        }
        return function;
    }

    private static void configureExecutionWorkspace(@Nullable GradleProjectSettings compositeRootSettings, GradleSettings settings, GradleExecutionSettings result, Project project, String projectPath) {
        if (compositeRootSettings == null || compositeRootSettings.getCompositeBuild() == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = compositeRootSettings.getCompositeBuild();
        if (compositeBuild.getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) {
            if (FileUtil.pathsEqual((String)compositeRootSettings.getExternalProjectPath(), (String)projectPath)) {
                return;
            }
            for (BuildParticipant buildParticipant : compositeBuild.getCompositeParticipants()) {
                if (FileUtil.pathsEqual((String)buildParticipant.getRootPath(), (String)projectPath) || buildParticipant.getProjects().stream().anyMatch(path -> FileUtil.pathsEqual((String)path, (String)projectPath))) continue;
                result.getExecutionWorkspace().addBuildParticipant(new GradleBuildParticipant(buildParticipant.getRootPath()));
            }
            return;
        }
        for (GradleProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            if (projectSettings == compositeRootSettings || compositeBuild.getCompositeParticipants().stream().noneMatch(participant -> FileUtil.pathsEqual((String)participant.getRootPath(), (String)projectSettings.getExternalProjectPath()))) continue;
            GradleBuildParticipant buildParticipant = new GradleBuildParticipant(projectSettings.getExternalProjectPath());
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                ModuleData moduleData = (ModuleData)moduleNode.getData();
                if (moduleData.getArtifacts().isEmpty()) {
                    Collection sourceSetNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY);
                    for (DataNode sourceSetNode : sourceSetNodes) {
                        buildParticipant.addModule((ModuleData)sourceSetNode.getData());
                    }
                    continue;
                }
                buildParticipant.addModule(moduleData);
            }
            result.getExecutionWorkspace().addBuildParticipant(buildParticipant);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            GradleManager.$$$reportNull$$$0(5);
        }
        HashSet additionalEntries = ContainerUtilRt.newHashSet();
        for (GradleProjectResolverExtension extension : (List)RESOLVER_EXTENSIONS.getValue()) {
            ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(extension.getClass()));
            for (Class aClass : extension.getExtraProjectModelClasses()) {
                ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass((Class)aClass));
            }
            extension.enhanceRemoteProcessing(parameters);
        }
        PathsList classPath = parameters.getClassPath();
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
        parameters.getVMParametersList().addProperty("external.system.id", GradleConstants.SYSTEM_ID.getId());
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<GradleExecutionSettings>> getProjectResolverClass() {
        if (GradleProjectResolver.class == null) {
            GradleManager.$$$reportNull$$$0(6);
        }
        return GradleProjectResolver.class;
    }

    public Class<? extends ExternalSystemTaskManager<GradleExecutionSettings>> getTaskManagerClass() {
        return GradleTaskManager.class;
    }

    @NotNull
    public Configurable getConfigurable(@NotNull Project project) {
        if (project == null) {
            GradleManager.$$$reportNull$$$0(7);
        }
        GradleConfigurable gradleConfigurable = new GradleConfigurable(project);
        if (gradleConfigurable == null) {
            GradleManager.$$$reportNull$$$0(8);
        }
        return gradleConfigurable;
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return FileChooserDescriptorFactory.createSingleFolderDescriptor();
    }

    @Nullable
    public Icon getProjectIcon() {
        return GradleIcons.GradleFile;
    }

    @Nullable
    public Icon getTaskIcon() {
        return DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (targetProjectPath == null) {
            GradleManager.$$$reportNull$$$0(9);
        }
        String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string == null) {
            GradleManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull Project project, @NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleManager.$$$reportNull$$$0(11);
        }
        if (targetProjectPath == null) {
            GradleManager.$$$reportNull$$$0(12);
        }
        if ((projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(targetProjectPath)) != null && projectSettings.getCompositeBuild() != null) {
            for (BuildParticipant buildParticipant : projectSettings.getCompositeBuild().getCompositeParticipants()) {
                if (!buildParticipant.getProjects().contains(targetProjectPath)) continue;
                String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)buildParticipant.getRootPath());
                if (string == null) {
                    GradleManager.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        String string = ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
        if (string == null) {
            GradleManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            GradleManager.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GradleManager.$$$reportNull$$$0(16);
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        if (project == null) {
            GradleManager.$$$reportNull$$$0(17);
        }
        return this.myAutoImportDelegate.getAffectedExternalProjectFiles(projectPath, project);
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = GradleUtil.getGradleProjectFileChooserDescriptor();
        if (fileChooserDescriptor == null) {
            GradleManager.$$$reportNull$$$0(18);
        }
        return fileChooserDescriptor;
    }

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings taskExecutionSettings) {
        String projectPath;
        if (project == null) {
            GradleManager.$$$reportNull$$$0(19);
        }
        if (taskExecutionSettings == null) {
            GradleManager.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmpty((String)(projectPath = taskExecutionSettings.getExternalProjectPath()))) {
            return null;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)((GradleSettings)((Object)this.getSettingsProvider().fun((Object)project))).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return null;
        }
        if (!projectSettings.isResolveModulePerSourceSet()) {
            return null;
        }
        Module[] modules = (Module[])Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(module -> StringUtil.equals((CharSequence)projectPath, (CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module))).toArray(Module[]::new);
        return modules.length > 0 ? SearchScopeProvider.createSearchScope((Module[])modules) : null;
    }

    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Project project, @NotNull Executor executor, @NotNull RunConfiguration runConfiguration) {
        if (project == null) {
            GradleManager.$$$reportNull$$$0(21);
        }
        if (executor == null) {
            GradleManager.$$$reportNull$$$0(22);
        }
        if (runConfiguration == null) {
            GradleManager.$$$reportNull$$$0(23);
        }
        return GradleIdeManager.getInstance().createTestConsoleProperties(project, executor, runConfiguration);
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            GradleManager.$$$reportNull$$$0(24);
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(GradleSettings.getInstance(project).getChangesTopic(), (Object)new GradleSettingsListenerAdapter(){

            @Override
            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                for (GradleProjectSettings projectSettings : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
                    ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectSettings.getExternalProjectPath());
                }
            }

            @Override
            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            @Override
            public void onGradleDistributionTypeChange(DistributionType currentValue, @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    2.$$$reportNull$$$0(1);
                }
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "linkedProjectPath";
                objectArray2[1] = "org/jetbrains/plugins/gradle/GradleManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGradleHomeChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onGradleDistributionTypeChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Map<String, String> adjustedPaths = GradleManager.patchLinkedProjects(project);
        if (adjustedPaths == null) {
            return;
        }
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(project);
        GradleManager.patchRecentTasks(adjustedPaths, localSettings);
        GradleManager.patchAvailableProjects(adjustedPaths, localSettings);
    }

    @Nullable
    private static Map<String, String> patchLinkedProjects(@NotNull Project project) {
        if (project == null) {
            GradleManager.$$$reportNull$$$0(25);
        }
        GradleSettings settings = GradleSettings.getInstance(project);
        ArrayList correctedSettings = ContainerUtilRt.newArrayList();
        HashMap adjustedPaths = ContainerUtilRt.newHashMap();
        for (GradleProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            String oldPath = projectSettings.getExternalProjectPath();
            if (oldPath != null && new File(oldPath).isFile() && FileUtilRt.extensionEquals((String)oldPath, (String)"gradle")) {
                try {
                    String newPath = new File(oldPath).getParentFile().getCanonicalPath();
                    projectSettings.setExternalProjectPath(newPath);
                    adjustedPaths.put(oldPath, newPath);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unexpected exception occurred on attempt to re-point linked gradle project path from build.gradle to its parent dir. Path: %s", oldPath), (Throwable)e);
                }
            }
            correctedSettings.add(projectSettings);
        }
        if (adjustedPaths.isEmpty()) {
            return null;
        }
        settings.setLinkedProjectsSettings(correctedSettings);
        return adjustedPaths;
    }

    private static void patchAvailableProjects(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            GradleManager.$$$reportNull$$$0(26);
        }
        if (localSettings == null) {
            GradleManager.$$$reportNull$$$0(27);
        }
        HashMap adjustedAvailableProjects = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : localSettings.getAvailableProjects().entrySet()) {
            String newPath = adjustedPaths.get(((ExternalProjectPojo)entry.getKey()).getPath());
            if (newPath == null) {
                adjustedAvailableProjects.put(entry.getKey(), entry.getValue());
                continue;
            }
            adjustedAvailableProjects.put(new ExternalProjectPojo(((ExternalProjectPojo)entry.getKey()).getName(), newPath), entry.getValue());
        }
        localSettings.setAvailableProjects(adjustedAvailableProjects);
    }

    private static void patchRecentTasks(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        if (adjustedPaths == null) {
            GradleManager.$$$reportNull$$$0(28);
        }
        if (localSettings == null) {
            GradleManager.$$$reportNull$$$0(29);
        }
        for (ExternalTaskExecutionInfo taskInfo : localSettings.getRecentTasks()) {
            ExternalSystemTaskExecutionSettings s = taskInfo.getSettings();
            String newPath = adjustedPaths.get(s.getExternalProjectPath());
            if (newPath == null) continue;
            s.setExternalProjectPath(newPath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/GradleManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProjectPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutionSettings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustedPaths";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/GradleManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionSettingsProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectResolverClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurable";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRepresentationName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRepresentationName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "patchLinkedProjects";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "patchAvailableProjects";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "patchRecentTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

