/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.filters;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.filters.GradleReRunBuildFilter;

public class ReRunTaskFilter
extends GradleReRunBuildFilter {
    private final ExecutionEnvironment myEnv;

    public ReRunTaskFilter(ExternalSystemExecuteTaskTask task, ExecutionEnvironment env) {
        super(task.getExternalProjectPath());
        this.myEnv = env;
    }

    @Override
    @NotNull
    protected HyperlinkInfo getHyperLinkInfo(List<String> options) {
        HyperlinkInfo hyperlinkInfo = project -> {
            Object params;
            RunnerAndConfigurationSettings settings = this.myEnv.getRunnerAndConfigurationSettings();
            if (settings == null) {
                return;
            }
            RunConfiguration conf = settings.getConfiguration();
            if (!(conf instanceof ExternalSystemRunConfiguration)) {
                return;
            }
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)conf).getSettings();
            String scriptParameters = taskExecutionSettings.getScriptParameters();
            if (StringUtil.isEmpty((String)scriptParameters)) {
                params = new SmartList();
            } else {
                params = StringUtil.split((String)scriptParameters, (String)" ");
                params.remove("--stacktrace");
                params.remove("--info");
                params.remove("--debug");
            }
            params.addAll(options);
            taskExecutionSettings.setScriptParameters(StringUtil.join((Collection)params, (String)" "));
            ExecutionUtil.restart((ExecutionEnvironment)this.myEnv);
        };
        if (hyperlinkInfo == null) {
            ReRunTaskFilter.$$$reportNull$$$0(0);
        }
        return hyperlinkInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/filters/ReRunTaskFilter", "getHyperLinkInfo"));
    }
}

