/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputWrapper
extends OutputStream {
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @Nullable
    private StringBuilder myBuffer;
    private final boolean myStdOut;

    public OutputWrapper(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId, boolean stdOut) {
        if (listener == null) {
            OutputWrapper.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            OutputWrapper.$$$reportNull$$$0(1);
        }
        this.myListener = listener;
        this.myTaskId = taskId;
        this.myStdOut = stdOut;
    }

    @Override
    public void write(int b) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        char c = (char)b;
        this.myBuffer.append(c);
        if (c == '\n') {
            this.doFlush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int start = off;
        int maxOffset = off + len;
        for (int i = off; i < maxOffset; ++i) {
            if (b[i] != 10) continue;
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, i - start + 1));
            this.doFlush();
            start = i + 1;
        }
        if (start < maxOffset) {
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, maxOffset - start));
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        this.myListener.onTaskOutput(this.myTaskId, this.myBuffer.toString(), this.myStdOut);
        this.myBuffer.setLength(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "taskId";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/service/execution/OutputWrapper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

