/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import icons.GradleIcons;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    public static final String[] BUILD_FILE_EXTENSIONS = new String[]{"gradle", "gradle.kts"};

    public String getName() {
        return GradleBundle.message("gradle.name", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    public boolean canOpenProject(VirtualFile file) {
        if (file.isDirectory()) {
            return Arrays.stream(file.getChildren()).anyMatch(GradleProjectOpenProcessor::canOpenFile);
        }
        return GradleProjectOpenProcessor.canOpenFile(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canOpenFile(VirtualFile file) {
        if (file.isDirectory()) return false;
        if (!Arrays.stream(BUILD_FILE_EXTENSIONS).anyMatch(file.getName()::endsWith)) return false;
        return true;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        projectToClose = forceOpenInNewFrame ? null : projectToClose;
        Path path = Paths.get(virtualFile.getPath(), new String[0]);
        return GradleProjectOpenProcessor.openGradleProject(null, projectToClose, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Project openGradleProject(@Nullable Project projectToOpen, @Nullable Project projectToClose, @NotNull Path path) {
        if (path == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        GradleProjectOpenProcessor gradleProjectOpenProcessor = (GradleProjectOpenProcessor)((Object)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(GradleProjectOpenProcessor.class));
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)false);
        if (virtualFile != null && virtualFile.isDirectory()) {
            for (VirtualFile file : virtualFile.getChildren()) {
                if (!gradleProjectOpenProcessor.canOpenProject(file)) continue;
                virtualFile = file;
                break;
            }
        }
        final String pathToOpen = virtualFile != null ? virtualFile.getParent().getPath() : path.toString();
        WizardContext wizardContext = new WizardContext(null, null);
        wizardContext.setProjectFileDirectory(pathToOpen);
        GradleProjectSettings gradleProjectSettings = GradleProjectOpenProcessor.createDefaultProjectSettings();
        gradleProjectSettings.setExternalProjectPath(pathToOpen);
        boolean jvmFound = GradleProjectOpenProcessor.setupGradleJvm((Project)ObjectUtils.chooseNotNull((Object)projectToOpen, (Object)projectToClose), gradleProjectSettings);
        GradleAbstractWizard wizard = new GradleAbstractWizard(wizardContext, gradleProjectSettings);
        AbstractExternalModuleBuilder<GradleProjectSettings> wizardBuilder = wizard.getBuilder();
        try {
            if (!jvmFound) {
                wizard.show();
            }
            if (jvmFound || 0 == wizard.getExitCode()) {
                if (projectToOpen == null) {
                    projectToOpen = ProjectManagerEx.getInstanceEx().newProject(wizardContext.getProjectName(), pathToOpen, true, false);
                }
                if (projectToOpen == null) {
                    Project project = null;
                    return project;
                }
                ExternalProjectsManagerImpl.getInstance((Project)projectToOpen).setStoreExternally(true);
                final VirtualFile finalVirtualFile = virtualFile;
                final Project finalProjectToOpen = projectToOpen;
                ExternalSystemApiUtil.subscribe((Project)projectToOpen, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)new GradleSettingsListenerAdapter(){

                    public void onProjectsLinked(@NotNull Collection<GradleProjectSettings> settings) {
                        if (settings == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        GradleProjectOpenProcessor.createProjectPreview(finalProjectToOpen, pathToOpen, finalVirtualFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/project/GradleProjectOpenProcessor$1", "onProjectsLinked"));
                    }
                });
                wizardBuilder.commit(projectToOpen, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
                projectToOpen.save();
                if (projectToClose != null) {
                    GradleProjectOpenProcessor.closePreviousProject(projectToClose);
                }
                projectToOpen.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
                if (!projectToOpen.isOpen()) {
                    ProjectManagerEx.getInstanceEx().openProject(projectToOpen);
                }
                Project project = projectToOpen;
                return project;
            }
        }
        finally {
            wizardBuilder.cleanup();
            Disposer.dispose((Disposable)wizard.getDisposable());
        }
        return null;
    }

    public static void attachGradleProjectAndRefresh(@NotNull Project project, @NotNull String gradleProjectPath) {
        if (project == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        if (gradleProjectPath == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        GradleProjectOpenProcessor.openGradleProject(project, null, Paths.get(gradleProjectPath, new String[0]));
    }

    @NotNull
    private static GradleProjectSettings createDefaultProjectSettings() {
        GradleProjectSettings settings = new GradleProjectSettings();
        settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        settings.setStoreProjectFilesExternally(ThreeState.YES);
        settings.setUseQualifiedModuleNames(true);
        GradleProjectSettings gradleProjectSettings = settings;
        if (gradleProjectSettings == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        return gradleProjectSettings;
    }

    private static void closePreviousProject(Project projectToClose) {
        int exitCode;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (exitCode = ProjectUtil.confirmOpenNewProject((boolean)true)) == 1) {
            ProjectUtil.closeAndDispose((Project)(projectToClose != null ? projectToClose : openProjects[openProjects.length - 1]));
        }
    }

    private static void attachGradleProjectAndRefresh(@NotNull Project project, @NotNull GradleProjectSettings gradleProjectSettings) {
        if (project == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        if (gradleProjectSettings == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        Runnable runnable = () -> {
            if (project == null) {
                GradleProjectOpenProcessor.$$$reportNull$$$0(14);
            }
            if (gradleProjectSettings == null) {
                GradleProjectOpenProcessor.$$$reportNull$$$0(15);
            }
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            settings.linkProject((ExternalProjectSettings)gradleProjectSettings);
            ImportSpec importSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).use(ProgressExecutionMode.IN_BACKGROUND_ASYNC).useDefaultCallback().build();
            ExternalSystemUtil.refreshProject((String)gradleProjectSettings.getExternalProjectPath(), (ImportSpec)importSpec);
        };
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> {
            if (project == null) {
                GradleProjectOpenProcessor.$$$reportNull$$$0(12);
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                if (project == null) {
                    GradleProjectOpenProcessor.$$$reportNull$$$0(13);
                }
                ExternalSystemUtil.ensureToolWindowInitialized((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            });
        });
        ExternalSystemUtil.invokeLater((Project)project, (ModalityState)ModalityState.NON_MODAL, (Runnable)runnable);
    }

    private static boolean setupGradleJvm(@Nullable Project project, @NotNull GradleProjectSettings projectSettings) {
        if (projectSettings == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(7);
        }
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
        if (!"#JAVA_INTERNAL".equals(sdkPair.first) || ExternalSystemJdkUtil.isValidJdk((String)((Sdk)sdkPair.second).getHomePath())) {
            projectSettings.setGradleJvm((String)sdkPair.first);
            return true;
        }
        String jdkPath = (String)ContainerUtil.iterateAndGetLastItem((Iterable)ExternalSystemJdkUtil.suggestJdkHomePaths());
        if (jdkPath != null) {
            Sdk sdk = ExternalSystemJdkUtil.addJdk((String)jdkPath);
            projectSettings.setGradleJvm(sdk.getName());
            return true;
        }
        return false;
    }

    private static void createProjectPreview(@NotNull Project project, @NotNull String rootProjectPath, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(8);
        }
        if (rootProjectPath == null) {
            GradleProjectOpenProcessor.$$$reportNull$$$0(9);
        }
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)rootProjectPath, (boolean)true, (ProgressExecutionMode)ProgressExecutionMode.MODAL_SYNC);
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> {
            if (project == null) {
                GradleProjectOpenProcessor.$$$reportNull$$$0(10);
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                if (project == null) {
                    GradleProjectOpenProcessor.$$$reportNull$$$0(11);
                }
                ExternalSystemUtil.ensureToolWindowInitialized((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                if (virtualFile == null) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile != null) {
                    ProjectView.getInstance((Project)project).selectPsiElement((PsiElement)psiFile, false);
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectOpenProcessor";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectOpenProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultProjectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openGradleProject";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachGradleProjectAndRefresh";
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupGradleJvm";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProjectPreview";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createProjectPreview$4";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$attachGradleProjectAndRefresh$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$attachGradleProjectAndRefresh$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleAbstractWizard
    extends AbstractWizard<ExternalModuleSettingsStep> {
        private final AbstractExternalModuleBuilder<GradleProjectSettings> myBuilder;

        GradleAbstractWizard(WizardContext wizardContext, GradleProjectSettings gradleProjectSettings) {
            super("Open Gradle Project", (Project)null);
            this.myBuilder = new AbstractExternalModuleBuilder<GradleProjectSettings>(GradleConstants.SYSTEM_ID, gradleProjectSettings){

                protected void setupModule(Module module) throws ConfigurationException {
                    super.setupModule(module);
                    ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalId(GradleConstants.SYSTEM_ID);
                    Project project = module.getProject();
                    FileDocumentManager.getInstance().saveAllDocuments();
                    GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
                    GradleProjectOpenProcessor.attachGradleProjectAndRefresh(project, gradleProjectSettings);
                }

                public void setupRootModel(ModifiableRootModel modifiableRootModel) {
                    String contentEntryPath = this.getContentEntryPath();
                    if (StringUtil.isEmpty((String)contentEntryPath)) {
                        return;
                    }
                    File contentRootDir = new File(contentEntryPath);
                    FileUtilRt.createDirectory((File)contentRootDir);
                    LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                    VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
                    if (modelContentRootDir == null) {
                        return;
                    }
                    modifiableRootModel.addContentEntry(modelContentRootDir);
                }

                public ModuleType getModuleType() {
                    return ModuleTypeManager.getInstance().getDefaultModuleType();
                }
            };
            GradleProjectSettingsControl settingsControl = new GradleProjectSettingsControl((GradleProjectSettings)this.myBuilder.getExternalProjectSettings());
            ExternalModuleSettingsStep<GradleProjectSettings> step = new ExternalModuleSettingsStep<GradleProjectSettings>(wizardContext, this.myBuilder, (AbstractExternalProjectSettingsControl)settingsControl){

                public void _commit(boolean finishChosen) throws CommitStepException {
                    try {
                        this.validate();
                        this.updateDataModel();
                    }
                    catch (ConfigurationException e) {
                        throw new CommitStepException(e.getMessage());
                    }
                }
            };
            this.addStep((Step)step);
            this.init();
        }

        @Nullable
        protected String getHelpID() {
            return null;
        }

        public AbstractExternalModuleBuilder<GradleProjectSettings> getBuilder() {
            return this.myBuilder;
        }
    }
}

