/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.SystemInfoRt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.incremental.LineOutputWriter;
import org.jetbrains.jps.javac.CompilationCanceledException;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavaCompilerToolExtension;
import org.jetbrains.jps.javac.JavacFileManager;
import org.jetbrains.jps.javac.JavacFileManager2;
import org.jetbrains.jps.javac.JpsInfoDiagnostic;
import org.jetbrains.jps.javac.JpsJavacFileManager;
import org.jetbrains.jps.javac.OptimizedFileManagerUtil;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;

public class JavacMain {
    private static final String JAVA_VERSION = System.getProperty("java.version", "");
    private static final boolean CUSTOM_JAVAC_FILE_MANAGER = Boolean.valueOf(System.getProperty("jps.custom.javac.file.manager", "false"));
    private static final Set<String> FILTERED_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-d", "-classpath", "-cp", "-bootclasspath")));
    private static final Set<String> FILTERED_SINGLE_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-verbose", "-proc:only", "-implicit:class", "-implicit:none", "-Xprefer:newer", "-Xprefer:source")));
    private static final Set<String> FILE_MANAGER_EARLY_INIT_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-encoding", "-extdirs", "-endorseddirs", "-processorpath", "-s", "-d", "-h")));
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    private static volatile boolean zipCacheCleanupPossible = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compile(Collection<String> options, Collection<? extends File> sources, Collection<? extends File> classpath, Collection<File> platformClasspath, Collection<? extends File> modulePath, Collection<? extends File> upgradeModulePath, Collection<? extends File> sourcePath, Map<File, Set<File>> outputDirToRoots, final DiagnosticOutputConsumer diagnosticConsumer, OutputFileConsumer outputSink, CanceledStatus canceledStatus, @NotNull JavaCompilingTool compilingTool) {
        block54: {
            JpsJavacFileManager fileManager;
            JavaCompiler compiler;
            if (compilingTool == null) {
                JavacMain.$$$reportNull$$$0(0);
            }
            try {
                compiler = compilingTool.createCompiler();
            }
            catch (CannotCreateJavaCompilerException e) {
                diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
                return false;
            }
            for (File outputDir : outputDirToRoots.keySet()) {
                outputDir.mkdirs();
            }
            final boolean usingJavac = compilingTool instanceof JavacCompilerTool;
            boolean javacBefore9 = JavacMain.isJavacBefore9(compilingTool);
            JpsJavacFileManager jpsJavacFileManager = fileManager = CUSTOM_JAVAC_FILE_MANAGER ? new JavacFileManager2(new ContextImpl(compiler, diagnosticConsumer, outputSink, canceledStatus, false), JavaSourceTransformer.getTransformers()) : new JavacFileManager(new ContextImpl(compiler, diagnosticConsumer, outputSink, canceledStatus, javacBefore9), JavaSourceTransformer.getTransformers());
            if (!platformClasspath.isEmpty()) {
                fileManager.handleOption("-bootclasspath", Collections.singleton("").iterator());
                fileManager.handleOption("-extdirs", Collections.singleton("").iterator());
                fileManager.handleOption("-endorseddirs", Collections.singleton("").iterator());
            }
            Collection<String> _options = JavacMain.prepareOptions(options, compilingTool);
            try {
                Iterator<String> iterator = _options.iterator();
                while (iterator.hasNext()) {
                    String option = iterator.next();
                    if (!FILE_MANAGER_EARLY_INIT_OPTIONS.contains(option)) continue;
                    fileManager.handleOption(option, iterator);
                }
                try {
                    fileManager.setOutputDirectories(outputDirToRoots);
                }
                catch (IOException e) {
                    fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                    boolean option = false;
                    fileManager.close();
                    if (usingJavac) {
                        JavacMain.cleanupJavacNameTable();
                    }
                    return option;
                }
                if (!classpath.isEmpty()) {
                    try {
                        fileManager.setLocation(StandardLocation.CLASS_PATH, classpath);
                        if (!usingJavac && !JavacMain.isOptionSet(options, "-processorpath")) {
                            fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, classpath);
                        }
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                if (!platformClasspath.isEmpty()) {
                    try {
                        fileManager.handleOption("-bootclasspath", Collections.singleton("").iterator());
                        fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, JavacMain.buildPlatformClasspath(platformClasspath, _options));
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                if (!upgradeModulePath.isEmpty()) {
                    try {
                        JavacMain.setModulePath(fileManager, "UPGRADE_MODULE_PATH", upgradeModulePath);
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                if (!modulePath.isEmpty()) {
                    try {
                        JavacMain.setModulePath(fileManager, "MODULE_PATH", modulePath);
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                if (javacBefore9 || !sourcePath.isEmpty() || modulePath.isEmpty()) {
                    try {
                        fileManager.setLocation(StandardLocation.SOURCE_PATH, sourcePath);
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                LineOutputWriter out = new LineOutputWriter(){

                    @Override
                    protected void lineAvailable(String line) {
                        if (usingJavac) {
                            diagnosticConsumer.outputLineAvailable(line);
                        }
                    }
                };
                JavaCompiler.CompilationTask task = compiler.getTask(out, JavacMain.wrapWithCallDispatcher(fileManager), diagnosticConsumer, _options, null, fileManager.getJavaFileObjectsFromFiles(sources));
                for (JavaCompilerToolExtension extension : JavaCompilerToolExtension.getExtensions()) {
                    try {
                        extension.beforeCompileTaskExecution(compilingTool, task, _options, diagnosticConsumer);
                    }
                    catch (Throwable e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.MANDATORY_WARNING, extension.getClass() + " : " + e.getMessage());
                        e.printStackTrace(System.err);
                    }
                }
                boolean bl = task.call();
                return bl;
            }
            catch (IllegalArgumentException e) {
                diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
            }
            catch (IllegalStateException e) {
                diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
            }
            catch (CompilationCanceledException ignored) {
                JavacMain.handleCancelException(diagnosticConsumer);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (cause instanceof CompilationCanceledException) {
                        JavacMain.handleCancelException(diagnosticConsumer);
                    } else {
                        diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
                    }
                    break block54;
                }
                throw e;
            }
            finally {
                fileManager.close();
                if (usingJavac) {
                    JavacMain.cleanupJavacNameTable();
                }
            }
        }
        return false;
    }

    private static void setModulePath(JpsJavacFileManager fileManager, String option, Collection<? extends File> path) throws IOException {
        JavaFileManager.Location location = StandardLocation.locationFor(option);
        if (location != null) {
            fileManager.setLocation(location, path);
        }
    }

    private static StandardJavaFileManager wrapWithCallDispatcher(final JpsJavacFileManager fileManager) {
        return (StandardJavaFileManager)Proxy.newProxyInstance(fileManager.getClass().getClassLoader(), new Class[]{StandardJavaFileManager.class}, new InvocationHandler(){
            private final Map<Method, Boolean> ourImplStatus = Collections.synchronizedMap(new HashMap());

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)this.getApiCallHandler(method), args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    throw cause != null ? cause : e;
                }
            }

            private JavaFileManager getApiCallHandler(Method method) {
                Boolean isImplemented = this.ourImplStatus.get(method);
                if (isImplemented == null) {
                    try {
                        fileManager.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                        isImplemented = Boolean.TRUE;
                    }
                    catch (NoSuchMethodException e) {
                        isImplemented = Boolean.FALSE;
                    }
                    this.ourImplStatus.put(method, isImplemented);
                }
                return isImplemented != false ? fileManager : fileManager.getStdManager();
            }
        });
    }

    private static boolean isJavacBefore9(JavaCompilingTool compilingTool) {
        return compilingTool instanceof JavacCompilerTool && (JAVA_RUNTIME_VERSION.startsWith("1.8.") || JAVA_RUNTIME_VERSION.startsWith("1.7.") || JAVA_RUNTIME_VERSION.startsWith("1.6."));
    }

    private static void handleCancelException(DiagnosticOutputConsumer diagnosticConsumer) {
        diagnosticConsumer.report(new JpsInfoDiagnostic("Compilation was canceled"));
    }

    private static boolean isAnnotationProcessingEnabled(Collection<String> options) {
        for (String option : options) {
            if (!"-proc:none".equals(option)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOptionSet(Collection<String> options, String option) {
        for (String opt : options) {
            if (!option.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> prepareOptions(Collection<String> options, @NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            JavacMain.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>(compilingTool.getDefaultCompilerOptions());
        boolean skip = false;
        for (String option : options) {
            if (FILTERED_OPTIONS.contains(option)) {
                skip = true;
                continue;
            }
            if (!(skip || FILTERED_SINGLE_OPTIONS.contains(option) || compilingTool.getDefaultCompilerOptions().contains(option))) {
                result.add(option);
            }
            skip = false;
        }
        compilingTool.preprocessOptions(result);
        return result;
    }

    private static Collection<File> buildPlatformClasspath(Collection<File> platformClasspath, Collection<String> options) {
        HashMap<PathOption, String> argsMap = new HashMap<PathOption, String>();
        Iterator<String> iterator = options.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            for (PathOption pathOption : PathOption.values()) {
                if (pathOption.parse(argsMap, arg, iterator)) break;
            }
        }
        if (argsMap.isEmpty()) {
            return platformClasspath;
        }
        ArrayList<File> result = new ArrayList<File>();
        JavacMain.appendFiles(argsMap, PathOption.PREPEND_CP, result, false);
        JavacMain.appendFiles(argsMap, PathOption.ENDORSED, result, true);
        JavacMain.appendFiles(argsMap, PathOption.D_ENDORSED, result, true);
        result.addAll(platformClasspath);
        JavacMain.appendFiles(argsMap, PathOption.APPEND_CP, result, false);
        JavacMain.appendFiles(argsMap, PathOption.EXTDIRS, result, true);
        JavacMain.appendFiles(argsMap, PathOption.D_EXTDIRS, result, true);
        return result;
    }

    private static void appendFiles(Map<PathOption, String> args, PathOption option, Collection<File> container, boolean listDir) {
        String path = args.get((Object)option);
        if (path == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (listDir) {
                File[] files = file.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    String fName = f.getName();
                    if (!fName.endsWith(".jar") && !fName.endsWith(".zip")) continue;
                    container.add(f);
                }
                continue;
            }
            container.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupJavacNameTable() {
        block5: {
            try {
                Field freelistField = NameTableCleanupDataHolder.freelistField;
                Object emptyList = NameTableCleanupDataHolder.emptyList;
                if (freelistField == null || emptyList == null) break block5;
                Class<?> clazz = freelistField.getDeclaringClass();
                synchronized (clazz) {
                    freelistField.set(null, emptyList);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void clearCompilerZipFileCache() {
        if (zipCacheCleanupPossible) {
            Method clearMethod = ZipFileIndexCleanupDataHolder.cacheClearMethod;
            if (clearMethod != null) {
                Method getter = ZipFileIndexCleanupDataHolder.cacheInstanceGetter;
                try {
                    Object instance = getter != null ? getter.invoke(null, new Object[0]) : null;
                    clearMethod.invoke(instance, new Object[0]);
                }
                catch (Throwable e) {
                    zipCacheCleanupPossible = false;
                }
            } else {
                zipCacheCleanupPossible = false;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "compilingTool";
        objectArray2[1] = "org/jetbrains/jps/javac/JavacMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ZipFileIndexCleanupDataHolder {
        @Nullable
        static final Method cacheInstanceGetter;
        @Nullable
        static final Method cacheClearMethod;

        private ZipFileIndexCleanupDataHolder() {
        }

        static {
            Method getterMethod = null;
            Method clearMethod = null;
            try {
                clearMethod = Class.forName("com.sun.tools.javac.zip.ZipFileIndex").getDeclaredMethod("clearCache", new Class[0]);
                clearMethod.setAccessible(true);
            }
            catch (Throwable e) {
                try {
                    Class<?> cacheClass = Class.forName("com.sun.tools.javac.file.ZipFileIndexCache");
                    clearMethod = cacheClass.getDeclaredMethod("clearCache", new Class[0]);
                    getterMethod = cacheClass.getDeclaredMethod("getSharedInstance", new Class[0]);
                    clearMethod.setAccessible(true);
                    getterMethod.setAccessible(true);
                }
                catch (Throwable ignored2) {
                    clearMethod = null;
                    getterMethod = null;
                }
            }
            cacheInstanceGetter = getterMethod;
            cacheClearMethod = clearMethod;
        }
    }

    private static final class NameTableCleanupDataHolder {
        static final Object emptyList;
        static final Field freelistField;

        private NameTableCleanupDataHolder() {
        }

        static {
            try {
                Field freelistRef;
                ClassLoader loader = ToolProvider.getSystemToolClassLoader();
                if (loader == null) {
                    throw new RuntimeException("no tools provided");
                }
                Class<?> listClass = Class.forName("com.sun.tools.javac.util.List", true, loader);
                Method nilMethod = listClass.getDeclaredMethod("nil", new Class[0]);
                emptyList = nilMethod.invoke(null, new Object[0]);
                try {
                    freelistRef = Class.forName("com.sun.tools.javac.util.Name$Table", true, loader).getDeclaredField("freelist");
                }
                catch (Exception e) {
                    freelistRef = Class.forName("com.sun.tools.javac.util.SharedNameTable", true, loader).getDeclaredField("freelist");
                }
                freelistRef.setAccessible(true);
                freelistField = freelistRef;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ContextImpl
    implements JpsJavacFileManager.Context {
        private final StandardJavaFileManager myStdManager;
        @Nullable
        private final Method myCacheClearMethod;
        private final DiagnosticOutputConsumer myOutConsumer;
        private final OutputFileConsumer myOutputFileSink;
        private final CanceledStatus myCanceledStatus;
        private static final AtomicBoolean ourOptimizedManagerMissingReported = new AtomicBoolean(false);

        ContextImpl(@NotNull JavaCompiler compiler, @NotNull DiagnosticOutputConsumer outConsumer, @NotNull OutputFileConsumer sink, CanceledStatus canceledStatus, boolean canUseOptimizedmanager) {
            if (compiler == null) {
                ContextImpl.$$$reportNull$$$0(0);
            }
            if (outConsumer == null) {
                ContextImpl.$$$reportNull$$$0(1);
            }
            if (sink == null) {
                ContextImpl.$$$reportNull$$$0(2);
            }
            this.myOutConsumer = outConsumer;
            this.myOutputFileSink = sink;
            this.myCanceledStatus = canceledStatus;
            StandardJavaFileManager optimizedManager = null;
            Method cacheClearMethod = null;
            if (canUseOptimizedmanager) {
                Class<StandardJavaFileManager> optimizedManagerClass = OptimizedFileManagerUtil.getManagerClass();
                if (optimizedManagerClass != null) {
                    try {
                        Constructor<StandardJavaFileManager> constructor = optimizedManagerClass.getConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        optimizedManager = constructor.newInstance(new Object[0]);
                        cacheClearMethod = OptimizedFileManagerUtil.getCacheClearMethod();
                    }
                    catch (Throwable e) {
                        if (SystemInfoRt.isWindows) {
                            ContextImpl.reportMissingOptimizedManager(outConsumer, e.getMessage());
                        }
                    }
                } else {
                    ContextImpl.reportMissingOptimizedManager(outConsumer, null);
                }
            }
            this.myCacheClearMethod = cacheClearMethod;
            this.myStdManager = optimizedManager != null ? optimizedManager : compiler.getStandardFileManager(outConsumer, Locale.US, null);
        }

        private static void reportMissingOptimizedManager(DiagnosticOutputConsumer outConsumer, String message) {
            if (!ourOptimizedManagerMissingReported.getAndSet(true)) {
                if (message == null && (message = OptimizedFileManagerUtil.getLoadError()) == null) {
                    message = "";
                }
                outConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.OTHER, "JPS build failed to load optimized file manager for javac:\n" + message));
            }
        }

        @Override
        public boolean isCanceled() {
            return this.myCanceledStatus.isCanceled();
        }

        @Override
        @NotNull
        public StandardJavaFileManager getStandardFileManager() {
            StandardJavaFileManager standardJavaFileManager = this.myStdManager;
            if (standardJavaFileManager == null) {
                ContextImpl.$$$reportNull$$$0(3);
            }
            return standardJavaFileManager;
        }

        @Override
        public void reportMessage(Diagnostic.Kind kind, String message) {
            this.myOutConsumer.report(new PlainMessageDiagnostic(kind, message));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void consumeOutputFile(@NotNull OutputFileObject cls) {
            Method cacheClearMethod;
            if (cls == null) {
                ContextImpl.$$$reportNull$$$0(4);
            }
            try {
                this.myOutputFileSink.save(cls);
                cacheClearMethod = this.myCacheClearMethod;
                if (cacheClearMethod == null) return;
            }
            catch (Throwable throwable) {
                Method cacheClearMethod2 = this.myCacheClearMethod;
                if (cacheClearMethod2 == null) throw throwable;
                try {
                    cacheClearMethod2.invoke((Object)this.myStdManager, cls.getFile());
                    throw throwable;
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                }
                throw throwable;
            }
            try {
                cacheClearMethod.invoke((Object)this.myStdManager, cls.getFile());
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compiler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/JavacMain$ContextImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/JavacMain$ContextImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStandardFileManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "consumeOutputFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum PathOption {
        PREPEND_CP("-Xbootclasspath/p:"),
        ENDORSED("-endorseddirs"),
        D_ENDORSED("-Djava.endorsed.dirs="),
        APPEND_CP("-Xbootclasspath/a:"),
        EXTDIRS("-extdirs"),
        D_EXTDIRS("-Djava.ext.dirs=");

        private final String myArgName;
        private final boolean myIsSuffix;

        private PathOption(String name) {
            this.myArgName = name;
            this.myIsSuffix = name.endsWith("=") || name.endsWith(":");
        }

        public boolean parse(Map<PathOption, String> container, String arg, Iterator<String> rest) {
            if (this.myIsSuffix) {
                if (arg.startsWith(this.myArgName)) {
                    container.put(this, arg.substring(this.myArgName.length()));
                    return true;
                }
            } else if (arg.equals(this.myArgName)) {
                if (rest.hasNext()) {
                    container.put(this, rest.next());
                }
                return true;
            }
            return false;
        }
    }
}

