/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompilerExcludes;
import com.intellij.compiler.ant.CompilerResourcePatterns;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.IgnoredFiles;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.LibraryPatterns;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class BuildPropertiesImpl
extends BuildProperties {
    public BuildPropertiesImpl(Project project2, GenerationOptions genOptions) {
        Generator globalLibs;
        LibraryTablesRegistrar registrar;
        LibraryDefinitionsGeneratorFactory factory;
        Generator projectLibs;
        this.add((Generator)new Property(genOptions.getPropertiesFileName()));
        this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.disable.tests.property.comment", (Object[])new Object[0]), (Generator)new Property("skip.tests", "true")));
        JpsJavaCompilerOptions javacSettings = JavacConfiguration.getOptions(project2, JavacConfiguration.class);
        this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.compiler.options.comment", (Object[])new Object[0])), 1);
        this.add((Generator)new Property("compiler.debug", javacSettings.DEBUGGING_INFO ? "on" : "off"), 1);
        this.add((Generator)new Property("compiler.generate.no.warnings", javacSettings.GENERATE_NO_WARNINGS ? "on" : "off"));
        this.add((Generator)new Property("compiler.args", javacSettings.ADDITIONAL_OPTIONS_STRING));
        int heapSize = CompilerConfiguration.getInstance((Project)project2).getBuildProcessHeapSize(javacSettings.MAXIMUM_HEAP_SIZE);
        this.add((Generator)new Property("compiler.max.memory", heapSize + "m"));
        this.add(new IgnoredFiles());
        if (CompilerExcludes.isAvailable(project2)) {
            this.add(new CompilerExcludes(project2, genOptions));
        }
        if (!genOptions.expandJarDirectories) {
            this.add(new LibraryPatterns(project2, genOptions));
        }
        this.add(new CompilerResourcePatterns(project2));
        if (genOptions.forceTargetJdk) {
            this.createJdkGenerators(project2);
        }
        if ((projectLibs = (factory = new LibraryDefinitionsGeneratorFactory((ProjectEx)project2, genOptions)).create((registrar = LibraryTablesRegistrar.getInstance()).getLibraryTable(project2), BuildPropertiesImpl.getProjectBaseDir((Project)project2), CompilerBundle.message((String)"generated.ant.build.project.libraries.comment", (Object[])new Object[0]))) != null) {
            this.add(projectLibs);
        }
        if ((globalLibs = factory.create(registrar.getLibraryTable(), null, CompilerBundle.message((String)"generated.ant.build.global.libraries.comment", (Object[])new Object[0]))) != null) {
            this.add(globalLibs);
        }
        for (LibraryTable table : registrar.getCustomLibraryTables()) {
            Generator appServerLibs;
            if (table.getLibraries().length == 0 || (appServerLibs = factory.create(table, null, table.getPresentation().getDisplayName(true))) == null) continue;
            this.add(appServerLibs);
        }
        ChunkCustomCompilerExtension[] customCompilers = genOptions.getCustomCompilers();
        if (genOptions.enableFormCompiler || customCompilers.length > 0) {
            this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.custom.compilers.comment", (Object[])new Object[0])));
            Target register = new Target("register.custom.compilers", null, null, null);
            if (genOptions.enableFormCompiler) {
                this.add((Generator)new Property("javac2.home", BuildPropertiesImpl.propertyRelativePath((String)"idea.home", (String)"lib")));
                Path javac2 = new Path("javac2.classpath");
                FileSet fileSet = new FileSet("${javac2.home}");
                fileSet.add((Generator)new Include("javac2.jar"));
                fileSet.add((Generator)new Include("jdom.jar"));
                fileSet.add((Generator)new Include("asm-all*.jar"));
                fileSet.add((Generator)new Include("forms-*.jar"));
                javac2.add((Generator)fileSet);
                this.add((Generator)javac2);
                register.add((Generator)new Tag("taskdef", new Pair[]{Pair.pair((Object)"name", (Object)"javac2"), Pair.pair((Object)"classname", (Object)"com.intellij.ant.Javac2"), Pair.pair((Object)"classpathref", (Object)"javac2.classpath")}));
                register.add((Generator)new Tag("taskdef", new Pair[]{Pair.pair((Object)"name", (Object)"instrumentIdeaExtensions"), Pair.pair((Object)"classname", (Object)"com.intellij.ant.InstrumentIdeaExtensions"), Pair.pair((Object)"classpathref", (Object)"javac2.classpath")}));
            }
            if (customCompilers.length > 0) {
                for (ChunkCustomCompilerExtension ext : customCompilers) {
                    ext.generateCustomCompilerTaskRegistration(project2, genOptions, (CompositeGenerator)register);
                }
            }
            this.add((Generator)register);
        }
    }

    protected void createJdkGenerators(Project project2) {
        Sdk projectJdk;
        Sdk[] jdks = BuildPropertiesImpl.getUsedJdks((Project)project2);
        if (jdks.length > 0) {
            this.add(new Comment(CompilerBundle.message((String)"generated.ant.build.jdk.definitions.comment", (Object[])new Object[0])), 1);
            for (Sdk jdk : jdks) {
                String[] urls;
                File homeDir;
                SdkTypeId sdkType;
                if (jdk.getHomeDirectory() == null || !((sdkType = jdk.getSdkType()) instanceof JavaSdkType) || ((JavaSdkType)sdkType).getBinPath(jdk) == null) continue;
                File home = VfsUtilCore.virtualToIoFile((VirtualFile)jdk.getHomeDirectory());
                try {
                    homeDir = home.getCanonicalFile();
                }
                catch (IOException e) {
                    homeDir = home;
                }
                String jdkName = jdk.getName();
                String jdkHomeProperty = BuildPropertiesImpl.getJdkHomeProperty((String)jdkName);
                FileSet fileSet = new FileSet(BuildPropertiesImpl.propertyRef((String)jdkHomeProperty));
                for (String url : urls = jdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
                    String path = GenerationUtils.trimJarSeparator((String)VirtualFileManager.extractPath((String)url));
                    File pathElement = new File(path);
                    String relativePath = FileUtil.getRelativePath((File)homeDir, (File)pathElement);
                    if (relativePath == null) continue;
                    fileSet.add((Generator)new Include(relativePath.replace(File.separatorChar, '/')));
                }
                File binPath = BuildPropertiesImpl.toCanonicalFile((File)new File(((JavaSdkType)sdkType).getBinPath(jdk)));
                String relativePath = FileUtil.getRelativePath((File)homeDir, (File)binPath);
                if (relativePath != null) {
                    this.add((Generator)new Property(BuildProperties.getJdkBinProperty((String)jdkName), BuildPropertiesImpl.propertyRef((String)jdkHomeProperty) + "/" + FileUtil.toSystemIndependentName((String)relativePath)), 1);
                } else {
                    this.add((Generator)new Property(BuildProperties.getJdkBinProperty((String)jdkName), FileUtil.toSystemIndependentName((String)binPath.getPath())), 1);
                }
                Path jdkPath = new Path(BuildPropertiesImpl.getJdkPathId((String)jdkName));
                jdkPath.add((Generator)fileSet);
                this.add((Generator)jdkPath);
            }
        }
        this.add((Generator)new Property("project.jdk.home", (projectJdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk()) != null ? BuildPropertiesImpl.propertyRef((String)BuildPropertiesImpl.getJdkHomeProperty((String)projectJdk.getName())) : ""), 1);
        this.add((Generator)new Property("project.jdk.bin", projectJdk != null ? BuildPropertiesImpl.propertyRef((String)BuildPropertiesImpl.getJdkBinProperty((String)projectJdk.getName())) : ""));
        this.add((Generator)new Property("project.jdk.classpath", projectJdk != null ? BuildPropertiesImpl.getJdkPathId((String)projectJdk.getName()) : ""));
    }
}

