/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.MessagesContainer;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContextEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileContextImpl");
    private final Project myProject;
    private final CompilerTask myBuildSession;
    private final MessagesContainer myMessages;
    private final boolean myShouldUpdateProblemsView;
    private CompileScope myCompileScope;
    private final boolean myMake;
    private final boolean myIsRebuild;
    private final boolean myIsAnnotationProcessorsEnabled;
    private boolean myRebuildRequested;
    private String myRebuildReason;
    private final ProjectFileIndex myProjectFileIndex;
    private final ProjectCompileScope myProjectCompileScope;
    private final long myStartCompilationStamp;
    private final UUID mySessionId;

    public CompileContextImpl(@NotNull Project project2, @NotNull CompilerTask compilerSession, @NotNull CompileScope compileScope, boolean isMake, boolean isRebuild) {
        if (project2 == null) {
            CompileContextImpl.$$$reportNull$$$0(0);
        }
        if (compilerSession == null) {
            CompileContextImpl.$$$reportNull$$$0(1);
        }
        if (compileScope == null) {
            CompileContextImpl.$$$reportNull$$$0(2);
        }
        this.mySessionId = UUID.randomUUID();
        this.myProject = project2;
        this.myMessages = new MessagesContainer(project2);
        this.myBuildSession = compilerSession;
        this.myCompileScope = compileScope;
        this.myMake = isMake;
        this.myIsRebuild = isRebuild;
        this.myStartCompilationStamp = System.currentTimeMillis();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myProjectCompileScope = new ProjectCompileScope(this.myProject);
        this.myIsAnnotationProcessorsEnabled = CompilerConfiguration.getInstance((Project)project2).isAnnotationProcessorsEnabled();
        Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)compileScope);
        if (sessionId != null) {
            compilerSession.setSessionId(sessionId);
        }
        CompilerWorkspaceConfiguration workspaceConfig = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myShouldUpdateProblemsView = workspaceConfig.MAKE_PROJECT_ON_SAVE;
    }

    @NotNull
    public CompilerTask getBuildSession() {
        CompilerTask compilerTask = this.myBuildSession;
        if (compilerTask == null) {
            CompileContextImpl.$$$reportNull$$$0(3);
        }
        return compilerTask;
    }

    public boolean shouldUpdateProblemsView() {
        return this.myShouldUpdateProblemsView;
    }

    public long getStartCompilationStamp() {
        return this.myStartCompilationStamp;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            CompileContextImpl.$$$reportNull$$$0(4);
        }
        return project2;
    }

    @NotNull
    public CompilerMessage[] getMessages(@NotNull CompilerMessageCategory category) {
        if (category == null) {
            CompileContextImpl.$$$reportNull$$$0(5);
        }
        CompilerMessage[] compilerMessageArray = this.myMessages.getMessages(category).toArray(CompilerMessage.EMPTY_ARRAY);
        if (compilerMessageArray == null) {
            CompileContextImpl.$$$reportNull$$$0(6);
        }
        return compilerMessageArray;
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
        if (category == null) {
            CompileContextImpl.$$$reportNull$$$0(7);
        }
        this.addMessage(category, message, url, lineNum, columnNum, null);
    }

    public void addMessage(@NotNull CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessage msg;
        if (category == null) {
            CompileContextImpl.$$$reportNull$$$0(8);
        }
        if ((msg = this.myMessages.addMessage(category, message, url, lineNum, columnNum, navigatable)) != null) {
            this.addToProblemsView(msg);
        }
    }

    @Override
    public void addMessage(CompilerMessage msg) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("addMessage: " + msg + " this=" + this);
        }
        if (this.myMessages.addMessage(msg)) {
            this.addToProblemsView(msg);
        }
    }

    private void addToProblemsView(CompilerMessage msg) {
        this.myBuildSession.addMessage(msg);
        if (this.myShouldUpdateProblemsView && msg.getCategory() == CompilerMessageCategory.ERROR) {
            ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, this.mySessionId);
        }
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myMessages.getMessageCount(category);
    }

    public CompileScope getCompileScope() {
        return this.myCompileScope;
    }

    public CompileScope getProjectCompileScope() {
        return this.myProjectCompileScope;
    }

    public void requestRebuildNextTime(String message) {
        if (!this.myRebuildRequested) {
            this.myRebuildRequested = true;
            this.myRebuildReason = message;
        }
    }

    public boolean isRebuildRequested() {
        return this.myRebuildRequested;
    }

    @Nullable
    public String getRebuildReason() {
        return this.myRebuildReason;
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myBuildSession.getIndicator();
        if (progressIndicator == null) {
            CompileContextImpl.$$$reportNull$$$0(9);
        }
        return progressIndicator;
    }

    public Module getModuleByFile(@NotNull VirtualFile file) {
        Module module2;
        if (file == null) {
            CompileContextImpl.$$$reportNull$$$0(10);
        }
        if ((module2 = this.myProjectFileIndex.getModuleForFile(file)) != null) {
            LOG.assertTrue(!module2.isDisposed());
            return module2;
        }
        return null;
    }

    public VirtualFile getModuleOutputDirectory(@NotNull Module module2) {
        if (module2 == null) {
            CompileContextImpl.$$$reportNull$$$0(11);
        }
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module2) {
        return CompilerPaths.getModuleOutputDirectory((Module)module2, (boolean)true);
    }

    public boolean isMake() {
        return this.myMake;
    }

    public boolean isAutomake() {
        return false;
    }

    public boolean isRebuild() {
        return this.myIsRebuild;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myIsAnnotationProcessorsEnabled;
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myCompileScope = new CompositeScope(this.myCompileScope, additionalScope);
    }

    public UUID getSessionId() {
        return this.mySessionId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileScope";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompileContextImpl";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompileContextImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSession";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

