/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.impl.javaCompiler.CompilerModuleOptionsComponent;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;

public class EclipseCompilerConfigurable
implements Configurable {
    private final Project myProject;
    private JPanel myPanel;
    private JCheckBox myCbDeprecation;
    private JCheckBox myCbDebuggingInfo;
    private JCheckBox myCbGenerateNoWarnings;
    private RawCommandLineEditor myAdditionalOptionsField;
    private JCheckBox myCbProceedOnErrors;
    private CompilerModuleOptionsComponent myOptionsOverride;
    private TextFieldWithBrowseButton myPathToEcjField;
    private final EclipseCompilerOptions myCompilerSettings;

    public EclipseCompilerConfigurable(Project project2, EclipseCompilerOptions options) {
        this.myProject = project2;
        this.myCompilerSettings = options;
        this.$$$setupUI$$$();
        this.myAdditionalOptionsField.setDialogCaption(CompilerBundle.message((String)"java.compiler.option.additional.command.line.parameters", (Object[])new Object[0]));
        this.myAdditionalOptionsField.setDescriptor(null, false);
        this.myPathToEcjField.addBrowseFolderListener("Path to ecj compiler tool", null, project2, new FileChooserDescriptor(true, false, true, true, false, false).withFileFilter(file -> file.getFileType() == StdFileTypes.ARCHIVE));
    }

    private void createUIComponents() {
        this.myOptionsOverride = new CompilerModuleOptionsComponent(this.myProject);
    }

    public String getDisplayName() {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        boolean isModified = false;
        isModified |= ComparingUtils.isModified(this.myCbDeprecation, this.myCompilerSettings.DEPRECATION);
        isModified |= ComparingUtils.isModified(this.myCbDebuggingInfo, this.myCompilerSettings.DEBUGGING_INFO);
        isModified |= ComparingUtils.isModified(this.myCbGenerateNoWarnings, this.myCompilerSettings.GENERATE_NO_WARNINGS);
        isModified |= ComparingUtils.isModified(this.myCbProceedOnErrors, this.myCompilerSettings.PROCEED_ON_ERROR);
        isModified |= ComparingUtils.isModified(this.myPathToEcjField, FileUtil.toSystemDependentName((String)this.myCompilerSettings.ECJ_TOOL_PATH));
        isModified |= ComparingUtils.isModified(this.myAdditionalOptionsField, this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
        return isModified |= !this.myOptionsOverride.getModuleOptionsMap().equals(this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    public void apply() throws ConfigurationException {
        this.myCompilerSettings.DEPRECATION = this.myCbDeprecation.isSelected();
        this.myCompilerSettings.DEBUGGING_INFO = this.myCbDebuggingInfo.isSelected();
        this.myCompilerSettings.GENERATE_NO_WARNINGS = this.myCbGenerateNoWarnings.isSelected();
        this.myCompilerSettings.PROCEED_ON_ERROR = this.myCbProceedOnErrors.isSelected();
        this.myCompilerSettings.ECJ_TOOL_PATH = FileUtil.toSystemIndependentName((String)this.myPathToEcjField.getText().trim());
        this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING = this.myAdditionalOptionsField.getText();
        this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE.clear();
        this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE.putAll(this.myOptionsOverride.getModuleOptionsMap());
    }

    public void reset() {
        this.myCbDeprecation.setSelected(this.myCompilerSettings.DEPRECATION);
        this.myCbDebuggingInfo.setSelected(this.myCompilerSettings.DEBUGGING_INFO);
        this.myCbGenerateNoWarnings.setSelected(this.myCompilerSettings.GENERATE_NO_WARNINGS);
        this.myCbProceedOnErrors.setSelected(this.myCompilerSettings.PROCEED_ON_ERROR);
        this.myPathToEcjField.setText(FileUtil.toSystemDependentName((String)this.myCompilerSettings.ECJ_TOOL_PATH));
        this.myAdditionalOptionsField.setText(this.myCompilerSettings.ADDITIONAL_OPTIONS_STRING);
        this.myOptionsOverride.setModuleOptionsMap(this.myCompilerSettings.ADDITIONAL_OPTIONS_OVERRIDE);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CompilerBundle").getString("eclipse.options.group.title"), (int)0, (int)0, null, null));
        this.myCbDeprecation = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.report.deprecated"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDebuggingInfo = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.debugging.info"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateNoWarnings = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.generate.no.warnings"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(10, 8, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myAdditionalOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(3, 0, 1, 5, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPathToEcjField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 5, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Path to ECJ batch compiler tool (leave empty to use bundled):");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("java.compiler.option.additional.command.line.parameters"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("('/' recommended in paths for cross-platform configurations)");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbProceedOnErrors = jCheckBox = new JCheckBox();
        jCheckBox.setText("Proceed on errors");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        CompilerModuleOptionsComponent compilerModuleOptionsComponent = this.myOptionsOverride;
        jPanel.add((Component)compilerModuleOptionsComponent, new GridConstraints(5, 0, 1, 1, 0, 1, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

