/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleFieldBreakpointAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Document document;
        Project project2;
        if (e == null) {
            ToggleFieldBreakpointAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        SourcePosition place = ToggleFieldBreakpointAction.getPlace(e);
        if (place != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(place.getFile())) != null) {
            FieldBreakpoint breakpoint;
            DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(project2);
            BreakpointManager manager = debuggerManager.getBreakpointManager();
            int offset = place.getOffset();
            FieldBreakpoint fieldBreakpoint = breakpoint = offset >= 0 ? manager.findBreakpoint(document, offset, FieldBreakpoint.CATEGORY) : null;
            if (breakpoint == null) {
                FieldBreakpoint fieldBreakpoint2 = manager.addFieldBreakpoint(document, offset);
                if (fieldBreakpoint2 != null) {
                    Editor editor;
                    ObjectReference object;
                    DebuggerTreeNodeImpl selectedNode;
                    if (DebuggerAction.isContextView(e) && (selectedNode = DebuggerAction.getSelectedNode(e.getDataContext())) != null && selectedNode.getDescriptor() instanceof FieldDescriptorImpl && (object = ((FieldDescriptorImpl)selectedNode.getDescriptor()).getObject()) != null) {
                        fieldBreakpoint2.setInstanceFilters(new InstanceFilter[]{InstanceFilter.create(object.uniqueID())});
                        fieldBreakpoint2.setInstanceFiltersEnabled(true);
                    }
                    if ((editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext())) != null) {
                        manager.editBreakpoint(fieldBreakpoint2, editor);
                    }
                }
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        SourcePosition place;
        if (event == null) {
            ToggleFieldBreakpointAction.$$$reportNull$$$0(1);
        }
        boolean toEnable = (place = ToggleFieldBreakpointAction.getPlace(event)) != null;
        Presentation presentation = event.getPresentation();
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace())) {
            presentation.setVisible(toEnable);
        } else if (DebuggerAction.isContextView(event)) {
            Document document;
            presentation.setText(DebuggerBundle.message((String)"action.add.field.watchpoint.text", (Object[])new Object[0]));
            Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
            if (project2 != null && place != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(place.getFile())) != null) {
                FieldBreakpoint fieldBreakpoint;
                int offset = place.getOffset();
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
                FieldBreakpoint fieldBreakpoint2 = fieldBreakpoint = offset >= 0 ? breakpointManager.findBreakpoint(document, offset, FieldBreakpoint.CATEGORY) : null;
                if (fieldBreakpoint != null) {
                    presentation.setEnabled(false);
                    return;
                }
            }
        }
        presentation.setVisible(toEnable);
    }

    @Nullable
    public static SourcePosition getPlace(AnActionEvent event) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl debugProcess;
        NodeDescriptorImpl descriptor2;
        DataContext dataContext = event.getDataContext();
        final Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return null;
        }
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace())) {
            PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiField) {
                return SourcePosition.createFromElement((PsiElement)psiElement);
            }
            return null;
        }
        XValue value = XDebuggerTreeActionBase.getSelectedValue((DataContext)dataContext);
        if (value instanceof NodeDescriptorProvider && (descriptor2 = ((NodeDescriptorProvider)value).getDescriptor()) instanceof FieldDescriptorImpl && (debugProcess = (debuggerContext = DebuggerAction.getDebuggerContext(dataContext)).getDebugProcess()) != null) {
            final Ref positionRef = new Ref(null);
            debugProcess.getManagerThread().invokeAndWait(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().runReadAction(() -> positionRef.set((Object)SourcePositionProvider.getSourcePosition(descriptor2, project2, debuggerContext)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ToggleFieldBreakpointAction$1", "threadAction"));
                }
            });
            SourcePosition sourcePosition = (SourcePosition)positionRef.get();
            if (sourcePosition != null) {
                return sourcePosition;
            }
        }
        if (DebuggerAction.isContextView(event)) {
            DebuggerTreeNodeImpl node;
            DebuggerTree tree = (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
            if (tree != null && tree.getSelectionPath() != null && (node = (DebuggerTreeNodeImpl)tree.getSelectionPath().getLastPathComponent()) != null && node.getDescriptor() instanceof FieldDescriptorImpl) {
                PsiField psiField;
                Field field = ((FieldDescriptorImpl)node.getDescriptor()).getField();
                DebuggerSession session = tree.getDebuggerContext().getDebuggerSession();
                PsiClass psiClass = DebuggerUtils.findClass((String)field.declaringType().name(), (Project)project2, (GlobalSearchScope)(session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project2)));
                if (psiClass != null && (psiField = (psiClass = (PsiClass)psiClass.getNavigationElement()).findFieldByName(field.name(), true)) != null) {
                    return SourcePosition.createFromElement((PsiElement)psiField);
                }
            }
            return null;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        if (editor != null) {
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            if (file != null) {
                PsiField field;
                FileType fileType;
                VirtualFile virtualFile = file.getVirtualFile();
                FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                if ((StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) && (field = FieldBreakpoint.findField(project2, document, editor.getCaretModel().getOffset())) != null) {
                    return SourcePosition.createFromElement((PsiElement)field);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/ToggleFieldBreakpointAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

