/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;

class UnaryExpressionEvaluator
implements Evaluator {
    private final IElementType myOperationType;
    private final String myExpectedType;
    private final Evaluator myOperandEvaluator;
    private final String myOperationText;

    UnaryExpressionEvaluator(IElementType operationType, String expectedType, Evaluator operandEvaluator, String operationText) {
        this.myOperationType = operationType;
        this.myExpectedType = expectedType;
        this.myOperandEvaluator = operandEvaluator;
        this.myOperationText = operationText;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value operand = (Value)this.myOperandEvaluator.evaluate(context);
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (this.myOperationType == JavaTokenType.PLUS) {
            if (DebuggerUtils.isNumeric((Value)operand)) {
                return operand;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.numeric.expected", (Object[])new Object[0]));
        }
        if (this.myOperationType == JavaTokenType.MINUS) {
            if (DebuggerUtils.isInteger((Value)operand)) {
                long v = ((PrimitiveValue)operand).longValue();
                return DebuggerUtilsEx.createValue(vm, this.myExpectedType, -v);
            }
            if (DebuggerUtils.isNumeric((Value)operand)) {
                double v = ((PrimitiveValue)operand).doubleValue();
                return DebuggerUtilsEx.createValue(vm, this.myExpectedType, -v);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.numeric.expected", (Object[])new Object[0]));
        }
        if (this.myOperationType == JavaTokenType.TILDE) {
            if (DebuggerUtils.isInteger((Value)operand)) {
                long v = ((PrimitiveValue)operand).longValue();
                return DebuggerUtilsEx.createValue(vm, this.myExpectedType, v ^ 0xFFFFFFFFFFFFFFFFL);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.integer.expected", (Object[])new Object[0]));
        }
        if (this.myOperationType == JavaTokenType.EXCL) {
            if (operand instanceof BooleanValue) {
                boolean v = ((BooleanValue)operand).booleanValue();
                return DebuggerUtilsEx.createValue(vm, this.myExpectedType, !v);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.operation.not.supported", (Object[])new Object[]{this.myOperationText}));
    }
}

