/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class Breakpoint<P extends JavaBreakpointProperties>
implements FilteredRequestor,
ClassPrepareRequestor,
OverheadProducer {
    public static final Key<Breakpoint> DATA_KEY = Key.create((String)"JavaBreakpoint");
    private static final Key<Long> HIT_COUNTER = Key.create((String)"HIT_COUNTER");
    final XBreakpoint<P> myXBreakpoint;
    protected final Project myProject;
    @NonNls
    private static final String LOG_MESSAGE_OPTION_NAME = "LOG_MESSAGE";
    protected boolean myCachedVerifiedState;

    protected Breakpoint(@NotNull Project project2, XBreakpoint<P> xBreakpoint) {
        if (project2 == null) {
            Breakpoint.$$$reportNull$$$0(0);
        }
        this.myCachedVerifiedState = false;
        this.myProject = project2;
        this.myXBreakpoint = xBreakpoint;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            Breakpoint.$$$reportNull$$$0(1);
        }
        return project2;
    }

    @NotNull
    protected P getProperties() {
        JavaBreakpointProperties javaBreakpointProperties = (JavaBreakpointProperties)this.myXBreakpoint.getProperties();
        if (javaBreakpointProperties == null) {
            Breakpoint.$$$reportNull$$$0(2);
        }
        return (P)((Object)javaBreakpointProperties);
    }

    public final XBreakpoint<P> getXBreakpoint() {
        return this.myXBreakpoint;
    }

    @Nullable
    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    static boolean shouldCreateRequest(Requestor requestor, XBreakpoint xBreakpoint, DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return (Boolean)ReadAction.compute(() -> {
            JavaDebugProcess process2 = debugProcess.getXdebugProcess();
            return !(process2 == null || !debugProcess.isAttached() || xBreakpoint != null && !((XDebugSessionImpl)process2.getSession()).isBreakpointActive(xBreakpoint) || !forPreparedClass && !debugProcess.getRequestsManager().findRequests(requestor).isEmpty());
        });
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return Breakpoint.shouldCreateRequest(this, this.getXBreakpoint(), debugProcess, forPreparedClass);
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess) {
        return this.shouldCreateRequest(debugProcess, false);
    }

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        if (this.myXBreakpoint != null) {
            renderer.setIcon(this.myXBreakpoint.getType().getEnabledIcon());
        } else {
            renderer.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        renderer.append(this.getDisplayName());
    }

    public abstract String getDisplayName();

    public String getShortName() {
        return this.getDisplayName();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean isVerified) {
        this.myCachedVerifiedState = isVerified;
    }

    public boolean isRemoveAfterHit() {
        return this.myXBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myXBreakpoint).isTemporary();
    }

    public void setRemoveAfterHit(boolean value) {
        if (this.myXBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myXBreakpoint).setTemporary(value);
        }
    }

    @Nullable
    public String getShortClassName() {
        String className = this.getClassName();
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        return dotIndex >= 0 && dotIndex + 1 < className.length() ? className.substring(dotIndex + 1) : className;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    protected String getStackTrace(LocatableEvent event) {
        StringBuilder builder = new StringBuilder(DebuggerBundle.message((String)"status.line.breakpoint.reached.full.trace", (Object[])new Object[0]));
        try {
            event.thread().frames().forEach(f -> builder.append("\n\t  ").append(ThreadDumpAction.renderLocation(f.location())));
        }
        catch (IncompatibleThreadStateException e) {
            builder.append("Stacktrace not available: ").append(e.getMessage());
        }
        return builder.toString();
    }

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        if (virtualMachineProxy.canBeModified()) {
            this.processClassesPrepare(debugProcess, virtualMachineProxy.classesByName(classToBeLoaded).stream());
        }
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, @NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            Breakpoint.$$$reportNull$$$0(3);
        }
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classPosition);
        if (debugProcess.getVirtualMachineProxy().canBeModified()) {
            this.processClassesPrepare(debugProcess, debugProcess.getPositionManager().getAllClasses(classPosition).stream().distinct());
        }
    }

    private void processClassesPrepare(DebugProcessImpl debugProcess, Stream<ReferenceType> classes) {
        classes.filter(ReferenceType::isPrepared).forEach(refType -> this.processClassPrepare(debugProcess, (ReferenceType)refType));
    }

    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxy;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (thread != null && (stackFrameProxy = thread.frame(0)) != null) {
            return stackFrameProxy.thisObject();
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context = action.getSuspendContext();
        if (!this.isValid()) {
            context.getDebugProcess().getRequestsManager().deleteRequest(this);
            return false;
        }
        String title = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0]);
        try {
            StackFrameProxyImpl frameProxy = context.getThread().frame(0);
            if (frameProxy == null) {
                return false;
            }
            EvaluationContextImpl evaluationContext = new EvaluationContextImpl(context, frameProxy, () -> this.getThisObject(context, event));
            if (!this.evaluateCondition(evaluationContext, event)) {
                return false;
            }
            title = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.runAction(evaluationContext, event);
        }
        catch (EvaluateException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println(ex.getMessage());
                return false;
            }
            throw new LocatableEventRequestor.EventProcessingException(title, ex.getMessage(), ex);
        }
        return true;
    }

    private void runAction(EvaluationContextImpl context, LocatableEvent event) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isLogEnabled() || this.isLogExpressionEnabled() || this.isLogStack()) {
            StringBuilder buf = new StringBuilder();
            if (this.myXBreakpoint.isLogMessage()) {
                buf.append(this.getEventMessage(event)).append("\n");
            }
            if (this.isLogStack()) {
                buf.append(this.getStackTrace(event)).append("\n");
            }
            if (this.isLogExpressionEnabled()) {
                if (!debugProcess.isAttached()) {
                    return;
                }
                TextWithImports logMessage = this.getLogMessage();
                try {
                    SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)context);
                    PsiElement element = ContextUtil.getContextElement((StackFrameContext)context, position);
                    ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> EvaluatorCache.cacheOrGet("LogMessageEvaluator", event.request(), element, logMessage, () -> Breakpoint.createExpressionEvaluator(this.myProject, element, position, logMessage, this::createLogMessageCodeFragment)));
                    Value eval = evaluator.evaluate((EvaluationContext)context);
                    buf.append(eval instanceof VoidValue ? "void" : DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)eval));
                }
                catch (EvaluateException e) {
                    buf.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0])).append(" \"").append(logMessage).append("\"").append(" : ").append(e.getMessage());
                }
                buf.append("\n");
            }
            if (buf.length() > 0) {
                debugProcess.printToConsole(buf.toString());
            }
        }
        if (this.isRemoveAfterHit()) {
            this.handleTemporaryBreakpointHit(debugProcess);
        }
    }

    private boolean hasObjectID(long id) {
        return Arrays.stream(this.getInstanceFilters()).anyMatch(instanceFilter -> instanceFilter.getId() == id);
    }

    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        ObjectReference reference;
        Value value;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isCountFilterEnabled() && !this.isConditionEnabled()) {
            debugProcess.getVirtualMachineProxy().suspend();
            debugProcess.getRequestsManager().deleteRequest(this);
            this.createRequest(debugProcess);
            debugProcess.getVirtualMachineProxy().resume();
        }
        StackFrameProxyImpl frame = context.getFrameProxy();
        if (((JavaBreakpointProperties)((Object)this.getProperties())).isCALLER_FILTERS_ENABLED() && frame != null) {
            String key;
            ThreadReferenceProxyImpl threadProxy = frame.threadProxy();
            StackFrameProxyImpl parentFrame = threadProxy.frameCount() > 1 ? threadProxy.frame(1) : null;
            String string = key = parentFrame != null ? DebuggerUtilsEx.methodKey(parentFrame.location().method()) : null;
            if (!Breakpoint.typeMatchesClassFilters(key, ((JavaBreakpointProperties)((Object)this.getProperties())).getCallerFilters(), ((JavaBreakpointProperties)((Object)this.getProperties())).getCallerExclusionFilters())) {
                return false;
            }
        }
        if (this.isInstanceFiltersEnabled() && (value = context.computeThisObject()) != null && !this.hasObjectID((reference = (ObjectReference)value).uniqueID())) {
            return false;
        }
        if (this.isClassFiltersEnabled() && !Breakpoint.typeMatchesClassFilters(this.calculateEventClass(context, event), this.getClassFilters(), this.getClassExclusionFilters())) {
            return false;
        }
        if (this.isConditionEnabled()) {
            ThreeState result;
            Location location;
            TextWithImports condition = this.getCondition();
            if (condition.isEmpty()) {
                return true;
            }
            if (frame != null && (location = frame.location()) != null && (result = debugProcess.getPositionManager().evaluateCondition(context, frame, location, condition.getText())) != ThreeState.UNSURE) {
                return result == ThreeState.YES;
            }
            try {
                SourcePosition contextSourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> {
                    PsiElement contextElement = ContextUtil.getContextElement(contextSourcePosition);
                    PsiElement contextPsiElement = contextElement != null ? contextElement : this.getEvaluationElement();
                    return EvaluatorCache.cacheOrGet("ConditionEvaluator", event.request(), contextPsiElement, condition, () -> Breakpoint.createExpressionEvaluator(this.myProject, contextPsiElement, contextSourcePosition, condition, this::createConditionCodeFragment));
                });
                if (!DebuggerUtilsEx.evaluateBoolean(evaluator, context)) {
                    return false;
                }
            }
            catch (EvaluateException ex) {
                if (ex.getCause() instanceof VMDisconnectedException) {
                    return false;
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{condition, ex.getMessage()}));
            }
        }
        if (this.isCountFilterEnabled() && this.isConditionEnabled()) {
            Long hitCount = (Long)ObjectUtils.notNull((Object)((Long)event.request().getProperty(HIT_COUNTER)), (Object)0L) + 1L;
            event.request().putProperty(HIT_COUNTER, hitCount);
            return hitCount % (long)this.getCountFilter() == 0L;
        }
        return true;
    }

    private static ExpressionEvaluator createExpressionEvaluator(Project project2, PsiElement contextPsiElement, SourcePosition contextSourcePosition, TextWithImports text, Function<PsiElement, PsiCodeFragment> fragmentFactory) throws EvaluateException {
        try {
            return EvaluatorBuilderImpl.build(text, contextPsiElement, contextSourcePosition, project2);
        }
        catch (UnsupportedExpressionException ex) {
            ExpressionEvaluator eval = CompilingEvaluatorImpl.create(project2, contextPsiElement, fragmentFactory);
            if (eval != null) {
                return eval;
            }
            throw ex;
        }
    }

    private PsiCodeFragment createConditionCodeFragment(PsiElement context) {
        return Breakpoint.createCodeFragment(this.myProject, this.getCondition(), context);
    }

    private PsiCodeFragment createLogMessageCodeFragment(PsiElement context) {
        return Breakpoint.createCodeFragment(this.myProject, this.getLogMessage(), context);
    }

    private static PsiCodeFragment createCodeFragment(Project project2, TextWithImports text, PsiElement context) {
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context).createCodeFragment(text, context, project2);
    }

    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        String className = null;
        ObjectReference thisObject = (ObjectReference)context.computeThisObject();
        if (thisObject != null) {
            className = thisObject.referenceType().name();
        } else {
            StackFrameProxyImpl frame = context.getFrameProxy();
            if (frame != null) {
                className = frame.location().declaringType().name();
            }
        }
        return className;
    }

    protected static boolean typeMatchesClassFilters(@Nullable String typeName, ClassFilter[] includeFilters, ClassFilter[] exludeFilters) {
        if (typeName == null) {
            return true;
        }
        boolean matches = false;
        boolean hasEnabled = false;
        for (ClassFilter classFilter2 : includeFilters) {
            if (!classFilter2.isEnabled()) continue;
            hasEnabled = true;
            if (!classFilter2.matches(typeName)) continue;
            matches = true;
            break;
        }
        if (hasEnabled && !matches) {
            return false;
        }
        return Arrays.stream(exludeFilters).noneMatch(classFilter -> classFilter.isEnabled() && classFilter.matches(typeName));
    }

    private void handleTemporaryBreakpointHit(final DebugProcessImpl debugProcess) {
        debugProcess.getRequestsManager().deleteRequest(this);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void resumed(SuspendContext suspendContext) {
                this.removeBreakpoint();
            }

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                if (process2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.removeBreakpoint();
            }

            private void removeBreakpoint() {
                AppUIUtil.invokeOnEdt(() -> DebuggerManagerEx.getInstanceEx(Breakpoint.this.myProject).getBreakpointManager().removeBreakpoint(Breakpoint.this));
                debugProcess.removeDebugProcessListener(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/ui/breakpoints/Breakpoint$1", "processDetached"));
            }
        });
    }

    public void updateUI() {
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        FilteredRequestorImpl requestor = new FilteredRequestorImpl(this.myProject);
        requestor.readTo(parentNode, this);
        try {
            this.setEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setLogEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String logMessage = JDOMExternalizerUtil.readField((Element)parentNode, (String)LOG_MESSAGE_OPTION_NAME);
            if (logMessage != null && !logMessage.isEmpty()) {
                XExpressionImpl expression = XExpressionImpl.fromText((String)logMessage);
                XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointLogExpression", (XExpression)expression);
                this.myXBreakpoint.setLogExpressionObject((XExpression)expression);
                ((XBreakpointBase)this.myXBreakpoint).setLogExpressionEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_EXPRESSION_ENABLED")).booleanValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setRemoveAfterHit(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"REMOVE_AFTER_HIT")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public abstract PsiElement getEvaluationElement();

    protected TextWithImports getLogMessage() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getLogExpressionObject());
    }

    protected TextWithImports getCondition() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getConditionExpression());
    }

    @Override
    public boolean isEnabled() {
        return this.myXBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myXBreakpoint.setEnabled(enabled);
    }

    protected boolean isLogEnabled() {
        return this.myXBreakpoint.isLogMessage();
    }

    public void setLogEnabled(boolean logEnabled) {
        this.myXBreakpoint.setLogMessage(logEnabled);
    }

    protected boolean isLogStack() {
        return this.myXBreakpoint.isLogStack();
    }

    protected boolean isLogExpressionEnabled() {
        if (XDebuggerUtilImpl.isEmptyExpression((XExpression)this.myXBreakpoint.getLogExpressionObject())) {
            return false;
        }
        return !this.getLogMessage().isEmpty();
    }

    @Override
    public boolean isCountFilterEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCOUNT_FILTER_ENABLED() && this.getCountFilter() > 0;
    }

    public void setCountFilterEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public int getCountFilter() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getCOUNT_FILTER();
    }

    public void setCountFilter(int filter) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER(filter)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCLASS_FILTERS_ENABLED();
    }

    public void setClassFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCLASS_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassFilters();
    }

    public void setClassFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassExclusionFilters();
    }

    public void setClassExclusionFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassExclusionFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isINSTANCE_FILTERS_ENABLED();
    }

    public void setInstanceFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setINSTANCE_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getInstanceFilters();
    }

    public void setInstanceFilters(InstanceFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setInstanceFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    private static String getSuspendPolicy(XBreakpoint breakpoint) {
        switch (breakpoint.getSuspendPolicy()) {
            case ALL: {
                return "SuspendAll";
            }
            case THREAD: {
                return "SuspendThread";
            }
            case NONE: {
                return "SuspendNone";
            }
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    static SuspendPolicy transformSuspendPolicy(String policy) {
        if ("SuspendAll".equals(policy)) {
            return SuspendPolicy.ALL;
        }
        if ("SuspendThread".equals(policy)) {
            return SuspendPolicy.THREAD;
        }
        if ("SuspendNone".equals(policy)) {
            return SuspendPolicy.NONE;
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    protected boolean isSuspend() {
        return this.myXBreakpoint.getSuspendPolicy() != SuspendPolicy.NONE;
    }

    @Override
    public String getSuspendPolicy() {
        return Breakpoint.getSuspendPolicy(this.myXBreakpoint);
    }

    public void setSuspendPolicy(String policy) {
        this.myXBreakpoint.setSuspendPolicy(Breakpoint.transformSuspendPolicy(policy));
    }

    @Override
    public boolean isConditionEnabled() {
        XExpression condition = this.myXBreakpoint.getConditionExpression();
        if (XDebuggerUtilImpl.isEmptyExpression((XExpression)condition)) {
            return false;
        }
        return !this.getCondition().isEmpty();
    }

    public void setCondition(@Nullable TextWithImports condition) {
        this.myXBreakpoint.setConditionExpression(TextWithImportsImpl.toXExpression(condition));
    }

    public void addInstanceFilter(long l) {
        ((JavaBreakpointProperties)((Object)this.getProperties())).addInstanceFilter(l);
    }

    protected void fireBreakpointChanged() {
        ((XBreakpointBase)this.myXBreakpoint).fireBreakpointChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/Breakpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/Breakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOrWaitPrepare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EvaluatorCache {
        private final PsiElement myContext;
        private final TextWithImports myTextWithImports;
        private final ExpressionEvaluator myEvaluator;

        private EvaluatorCache(PsiElement context, TextWithImports textWithImports, ExpressionEvaluator evaluator) {
            this.myContext = context;
            this.myTextWithImports = textWithImports;
            this.myEvaluator = evaluator;
        }

        @Nullable
        static ExpressionEvaluator cacheOrGet(String propertyName, EventRequest request, PsiElement context, TextWithImports text, EvaluatingComputable<? extends ExpressionEvaluator> supplier) throws EvaluateException {
            EvaluatorCache cache = (EvaluatorCache)request.getProperty(propertyName);
            if (cache != null && Objects.equals(cache.myContext, context) && Objects.equals(cache.myTextWithImports, text)) {
                return cache.myEvaluator;
            }
            ExpressionEvaluator evaluator = supplier.compute();
            request.putProperty(propertyName, new EvaluatorCache(context, text, evaluator));
            return evaluator;
        }
    }
}

