/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PairFunction;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaMethodBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties> {
    public JavaMethodBreakpointType() {
        super("java-method", DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    static String getText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        boolean classNameExists;
        StringBuilder buffer = new StringBuilder();
        String className = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).myClassPattern;
        boolean bl = classNameExists = className != null && className.length() > 0;
        if (classNameExists) {
            buffer.append(className);
        }
        if (((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName != null) {
            if (classNameExists) {
                buffer.append(".");
            }
            buffer.append(((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName);
        }
        return buffer.toString();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(6);
        }
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(7);
        }
        JavaMethodBreakpointProperties properties = new JavaMethodBreakpointProperties();
        if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
            properties.EMULATED = true;
        }
        return properties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint(project2, breakpoint);
        if (methodBreakpoint == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(8);
        }
        return methodBreakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project2) {
        if (file == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(10);
        }
        return JavaMethodBreakpointType.canPutAtElement(file, line, project2, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(element, document) -> element instanceof PsiMethod));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

