/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends SyntheticLineBreakpoint {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;

    protected RunToCursorBreakpoint(@NotNull Project project2, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        if (project2 == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myCustomPosition = pos;
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    @NotNull
    public SourcePosition getSourcePosition() {
        SourcePosition sourcePosition = this.myCustomPosition;
        if (sourcePosition == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(2);
        }
        return sourcePosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    protected String getFileName() {
        return this.myCustomPosition.getFile().getName();
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return DebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        SourcePosition position = this.getSourcePosition();
        VirtualFile file = position.getFile().getVirtualFile();
        int line = position.getLine();
        for (XLineBreakpointType type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!(type instanceof JavaLineBreakpointType) || !type.canPutAt(file, line, this.myProject)) continue;
            return (JavaLineBreakpointType)type;
        }
        return null;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project2, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        PsiFile psiFile;
        if (project2 == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(3);
        }
        if (position == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(4);
        }
        if ((psiFile = PsiManager.getInstance((Project)project2).findFile(position.getFile())) == null) {
            return null;
        }
        return new RunToCursorBreakpoint(project2, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

