/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadTimings {
    public static final Key<OverheadTimings> KEY = Key.create((String)"OVERHEAD_TIMINGS");
    private final EventDispatcher<OverheadTimingsListener> myEventDispatcher = EventDispatcher.create(OverheadTimingsListener.class);
    private final Map<OverheadProducer, Timings> myMap = new ConcurrentHashMap<OverheadProducer, Timings>();
    private final List<Pair<Long, Timings>> myLast10Elements = new LinkedList<Pair<Long, Timings>>(){

        @Override
        public boolean add(Pair<Long, Timings> o) {
            if (this.size() > 10) {
                this.removeFirst();
            }
            boolean res = super.add(o);
            if (this.isExcessive()) {
                ((OverheadTimingsListener)OverheadTimings.this.myEventDispatcher.getMulticaster()).excessiveOverheadDetected();
            }
            return res;
        }

        private boolean isExcessive() {
            if (this.size() < 5) {
                return false;
            }
            long totalTime = StreamEx.of((Collection)this).map(p -> ((Timings)p.getSecond()).myTime).nonNull().mapToLong(l -> l).sum();
            return totalTime > (Long)((Pair)this.getLast()).first - (Long)((Pair)this.getFirst()).first;
        }
    };

    public static Long getTime(DebugProcess process2, OverheadProducer producer) {
        Timings timings = OverheadTimings.getTimings((DebugProcess)process2).myMap.get(producer);
        return timings != null ? timings.myTime : null;
    }

    public static long getHits(DebugProcess process2, OverheadProducer producer) {
        Timings timings = OverheadTimings.getTimings((DebugProcess)process2).myMap.get(producer);
        return timings != null ? timings.myHits : 0L;
    }

    public static Set<OverheadProducer> getProducers(DebugProcess process2) {
        return OverheadTimings.getTimings((DebugProcess)process2).myMap.keySet();
    }

    public static void add(DebugProcess process2, OverheadProducer producer, long hits, @Nullable Long overhead) {
        OverheadTimings timings = OverheadTimings.getTimings(process2);
        Timings newTiming = new Timings(hits, overhead);
        timings.myLast10Elements.add((Pair<Long, Timings>)Pair.create((Object)System.currentTimeMillis(), (Object)newTiming));
        timings.myMap.merge(producer, newTiming, (old, value) -> {
            Long newTime = old.myTime;
            if (value.myTime != null) {
                newTime = newTime + value.myTime;
            }
            return new Timings(old.myHits + value.myHits, newTime);
        });
        ((OverheadTimingsListener)timings.myEventDispatcher.getMulticaster()).timingAdded(producer);
    }

    @NotNull
    private static OverheadTimings getTimings(DebugProcess process2) {
        OverheadTimings data = (OverheadTimings)process2.getUserData(KEY);
        if (data == null) {
            data = new OverheadTimings();
            process2.putUserData(KEY, (Object)data);
        }
        OverheadTimings overheadTimings = data;
        if (overheadTimings == null) {
            OverheadTimings.$$$reportNull$$$0(0);
        }
        return overheadTimings;
    }

    static void addListener(OverheadTimingsListener listener, DebugProcess process2) {
        OverheadTimings.getTimings((DebugProcess)process2).myEventDispatcher.addListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/overhead/OverheadTimings", "getTimings"));
    }

    public static interface OverheadTimingsListener
    extends EventListener {
        public void timingAdded(OverheadProducer var1);

        public void excessiveOverheadDetected();
    }

    private static class Timings {
        final long myHits;
        final Long myTime;

        Timings(long hits, Long time) {
            this.myHits = hits;
            this.myTime = time;
        }
    }
}

