/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.IntArrayExternalizer;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DiscoveredTestsIndex
extends MapReduceIndex<Integer, TIntArrayList, UsedSources> {
    private static final IndexExtension<Integer, TIntArrayList, UsedSources> INDEX_EXTENSION = new IndexExtension<Integer, TIntArrayList, UsedSources>(){

        @NotNull
        public IndexId<Integer, TIntArrayList> getName() {
            IndexId indexId = IndexId.create((String)"jvm.discovered.tests");
            if (indexId == null) {
                2.$$$reportNull$$$0(0);
            }
            return indexId;
        }

        @NotNull
        public DataIndexer<Integer, TIntArrayList, UsedSources> getIndexer() {
            DataIndexer dataIndexer = inputData -> inputData.myUsedMethods;
            if (dataIndexer == null) {
                2.$$$reportNull$$$0(1);
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                2.$$$reportNull$$$0(2);
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<TIntArrayList> getValueExternalizer() {
            IntArrayExternalizer intArrayExternalizer = IntArrayExternalizer.INSTANCE;
            if (intArrayExternalizer == null) {
                2.$$$reportNull$$$0(3);
            }
            return intArrayExternalizer;
        }

        public int getVersion() {
            return 10;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestsIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueExternalizer";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    protected DiscoveredTestsIndex(final @NotNull File file) throws IOException {
        if (file == null) {
            DiscoveredTestsIndex.$$$reportNull$$$0(0);
        }
        super(INDEX_EXTENSION, (IndexStorage)new MyIndexStorage(file), (ForwardIndex)new MyForwardIndex(){

            @NotNull
            public PersistentHashMap<Integer, Collection<Integer>> createMap() throws IOException {
                PersistentHashMap persistentHashMap = new PersistentHashMap(new File(file, "forward.idx"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntCollectionDataExternalizer());
                if (persistentHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return persistentHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/indices/DiscoveredTestsIndex$1", "createMap"));
            }
        });
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable e) {
        if (e == null) {
            DiscoveredTestsIndex.$$$reportNull$$$0(1);
        }
    }

    public boolean containsDataFrom(int testId) throws IOException {
        return ((MyForwardIndex)this.myForwardIndex).containsDataFrom(testId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestRebuild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class MyForwardIndex
    extends KeyCollectionBasedForwardIndex<Integer, TIntArrayList> {
        protected MyForwardIndex() throws IOException {
            super(INDEX_EXTENSION);
        }

        public boolean containsDataFrom(int testId) throws IOException {
            return this.getInput(testId) != null;
        }
    }

    private static class MyIndexStorage
    extends MapIndexStorage<Integer, TIntArrayList> {
        protected MyIndexStorage(@NotNull File storageFile) throws IOException {
            if (storageFile == null) {
                MyIndexStorage.$$$reportNull$$$0(0);
            }
            super(storageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)IntArrayExternalizer.INSTANCE, 4096, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageFile", "com/intellij/execution/testDiscovery/indices/DiscoveredTestsIndex$MyIndexStorage", "<init>"));
        }
    }
}

