/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestModuleIndex {
    private static final Logger LOG = Logger.getInstance(TestModuleIndex.class);
    private final PersistentHashMap<Integer, TIntArrayList> myTestNameToRunModule;
    private final PersistentEnumeratorDelegate<String> myModuleNameEnumerator;

    public TestModuleIndex(@NotNull Path basePath, @NotNull PersistentObjectSeq persistentObjectSeq) throws IOException {
        if (basePath == null) {
            TestModuleIndex.$$$reportNull$$$0(0);
        }
        if (persistentObjectSeq == null) {
            TestModuleIndex.$$$reportNull$$$0(1);
        }
        File moduleNameEnumeratorFile = basePath.resolve("moduleName.enum").toFile();
        this.myModuleNameEnumerator = new PersistentEnumeratorDelegate(moduleNameEnumeratorFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 64);
        persistentObjectSeq.add(this.myModuleNameEnumerator);
        File testModuleIndexFile = basePath.resolve("testModule.index").toFile();
        this.myTestNameToRunModule = new PersistentHashMap(testModuleIndexFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntSeqExternalizer());
    }

    void appendModuleData(int testId, @Nullable String moduleName) throws IOException {
        if (moduleName != null) {
            int moduleId = this.myModuleNameEnumerator.enumerate((Object)moduleName);
            TIntArrayList previousRunModules = (TIntArrayList)this.myTestNameToRunModule.get((Object)moduleId);
            if (previousRunModules != null && previousRunModules.contains(moduleId)) {
                return;
            }
            this.myTestNameToRunModule.appendData((Object)testId, out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)moduleId));
        }
    }

    @NotNull
    Collection<String> getTestRunModules(int testId) throws IOException {
        TIntArrayList moduleIds = (TIntArrayList)this.myTestNameToRunModule.get((Object)testId);
        if (moduleIds == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TestModuleIndex.$$$reportNull$$$0(2);
            }
            return set;
        }
        ArrayList<String> result = new ArrayList<String>(moduleIds.size());
        for (int i = 0; i < moduleIds.size(); ++i) {
            int moduleId = moduleIds.get(i);
            String moduleName = (String)this.myModuleNameEnumerator.valueOf(moduleId);
            if (!LOG.assertTrue(moduleName != null)) continue;
            result.add(moduleName);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            TestModuleIndex.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    void removeTest(int testId) throws IOException {
        this.myTestNameToRunModule.remove((Object)testId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentObjectSeq";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntSeqExternalizer
    implements DataExternalizer<TIntArrayList> {
        private IntSeqExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntArrayList testNameIds) throws IOException {
            if (dataOutput == null) {
                IntSeqExternalizer.$$$reportNull$$$0(0);
            }
            for (int testNameId : testNameIds.toNativeArray()) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
            }
        }

        public TIntArrayList read(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                IntSeqExternalizer.$$$reportNull$$$0(1);
            }
            TIntHashSet result = new TIntHashSet();
            while (((InputStream)((Object)dataInput)).available() > 0) {
                int id = DataInputOutputUtil.readINT((DataInput)dataInput);
                result.add(id);
            }
            return new TIntArrayList(result.toArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/testDiscovery/indices/TestModuleIndex$IntSeqExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

