/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JavaAnonymousClassTreeElement
extends JavaClassTreeElement {
    public static final JavaAnonymousClassTreeElement[] EMPTY_ARRAY = new JavaAnonymousClassTreeElement[0];
    private String myName;
    private String myBaseName;

    public JavaAnonymousClassTreeElement(PsiAnonymousClass aClass) {
        super((PsiClass)aClass, false);
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public String getPresentableText() {
        if (this.myName != null) {
            return this.myName;
        }
        PsiClass element = (PsiClass)this.getElement();
        if (element != null) {
            this.myName = JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)element));
            if (this.myName != null) {
                return this.myName;
            }
        }
        return "Anonymous";
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    @Override
    public String getLocationString() {
        PsiAnonymousClass anonymousClass;
        if (this.myBaseName == null && (anonymousClass = (PsiAnonymousClass)this.getElement()) != null) {
            this.myBaseName = anonymousClass.getBaseClassType().getClassName();
        }
        return this.myBaseName;
    }

    public String toString() {
        return super.toString() + (this.myBaseName == null ? "" : " (" + this.getLocationString() + ")");
    }

    public Icon getIcon(boolean open) {
        return PlatformIcons.ANONYMOUS_CLASS_ICON;
    }
}

