/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.impl.DownloadableLibraryDescriptionImpl;
import com.intellij.framework.library.impl.DownloadableLibraryFileDescriptionImpl;
import com.intellij.framework.library.impl.FrameworkLibraryVersionImpl;
import com.intellij.ide.util.frameworkSupport.CustomLibraryDescriptionBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OldCustomLibraryDescription
extends CustomLibraryDescriptionBase {
    private final DownloadableLibraryDescription myDownloadableDescription;
    private final List<FrameworkVersion> myVersions;

    public OldCustomLibraryDescription(@NotNull LibraryInfo[] libraryInfos, @NotNull String defaultLibraryName) {
        if (libraryInfos == null) {
            OldCustomLibraryDescription.$$$reportNull$$$0(0);
        }
        if (defaultLibraryName == null) {
            OldCustomLibraryDescription.$$$reportNull$$$0(1);
        }
        this(Collections.singletonList(new FrameworkVersion(defaultLibraryName, defaultLibraryName, libraryInfos, true)), defaultLibraryName);
    }

    private OldCustomLibraryDescription(List<FrameworkVersion> versions, String defaultLibraryName) {
        super(defaultLibraryName);
        this.myVersions = versions;
        ArrayList<FrameworkLibraryVersionImpl> libraryVersions = new ArrayList<FrameworkLibraryVersionImpl>();
        for (FrameworkVersion version : versions) {
            ArrayList<DownloadableLibraryFileDescriptionImpl> downloads = new ArrayList<DownloadableLibraryFileDescriptionImpl>();
            for (LibraryInfo info : version.getLibraries()) {
                LibraryDownloadInfo downloadingInfo = info.getDownloadingInfo();
                if (downloadingInfo == null) continue;
                downloads.add(new DownloadableLibraryFileDescriptionImpl(downloadingInfo.getDownloadUrl(), downloadingInfo.getFileNamePrefix(), downloadingInfo.getFileNameSuffix(), null, null, false));
            }
            String libraryName = version.getLibraryName();
            libraryVersions.add(new FrameworkLibraryVersionImpl(libraryName, version.getVersionName(), FrameworkAvailabilityCondition.ALWAYS_TRUE, downloads, libraryName));
        }
        this.myDownloadableDescription = !libraryVersions.isEmpty() ? new DownloadableLibraryDescriptionImpl(libraryVersions) : null;
    }

    public DownloadableLibraryDescription getDownloadableDescription() {
        return this.myDownloadableDescription;
    }

    public boolean isSuitableLibrary(@NotNull Library library, @NotNull LibrariesContainer container) {
        if (library == null) {
            OldCustomLibraryDescription.$$$reportNull$$$0(2);
        }
        if (container == null) {
            OldCustomLibraryDescription.$$$reportNull$$$0(3);
        }
        for (FrameworkVersion version : this.myVersions) {
            RequiredLibrariesInfo info = new RequiredLibrariesInfo(version.getLibraries());
            if (info.checkLibraries(container.getLibraryFiles(library, OrderRootType.CLASSES)) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        Set set = Collections.emptySet();
        if (set == null) {
            OldCustomLibraryDescription.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    public static CustomLibraryDescription createByVersions(List<? extends FrameworkVersion> versions) {
        String defaultLibraryName = null;
        ArrayList<FrameworkVersion> withLibraries = new ArrayList<FrameworkVersion>();
        for (FrameworkVersion frameworkVersion : versions) {
            if (frameworkVersion.getLibraries().length <= 0) continue;
            if (frameworkVersion.isDefault()) {
                defaultLibraryName = frameworkVersion.getLibraryName();
            }
            withLibraries.add(frameworkVersion);
        }
        if (withLibraries.isEmpty()) {
            return null;
        }
        if (defaultLibraryName == null) {
            defaultLibraryName = ((FrameworkVersion)withLibraries.get(0)).getLibraryName();
        }
        return new OldCustomLibraryDescription(withLibraries, defaultLibraryName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLibraryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/frameworkSupport/OldCustomLibraryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/frameworkSupport/OldCustomLibraryDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableLibraryKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableLibrary";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

