/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger LOG = Logger.getInstance(AbstractAttachSourceProvider.class);

    @Nullable
    protected static VirtualFile getJarByPsiFile(@Nullable PsiFile psiFile) {
        VirtualFileSystem fs;
        VirtualFile entry;
        if (psiFile != null && (entry = psiFile.getVirtualFile()) != null && (fs = entry.getFileSystem()) instanceof JarFileSystem) {
            return ((JarFileSystem)fs).getLocalByEntry(entry);
        }
        return null;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(List<? extends LibraryOrderEntry> orderEntries) {
        if (orderEntries.isEmpty()) {
            return null;
        }
        Library library = orderEntries.get(0).getLibrary();
        if (library == null) {
            return null;
        }
        for (int i = 1; i < orderEntries.size(); ++i) {
            if (library.equals(orderEntries.get(i).getLibrary())) continue;
            return null;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile jarRoot, @NotNull Library library) {
        if (library == null) {
            AbstractAttachSourceProvider.$$$reportNull$$$0(0);
        }
        if (jarRoot != null && !Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(jarRoot)) {
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(jarRoot, OrderRootType.SOURCES);
            model.commit();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/jarFinder/AbstractAttachSourceProvider", "addSourceFile"));
    }

    protected static abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;

        public DownloadSourcesAction(Project project2, String messageGroupId, String url) {
            this.myProject = project2;
            this.myUrl = url;
            this.myMessageGroupId = messageGroupId;
        }

        public String getName() {
            return "Download Sources";
        }

        public String getBusyText() {
            return "Downloading Sources...";
        }

        protected abstract void storeFile(byte[] var1);

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            final ActionCallback callback = new ActionCallback();
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Downloading Sources", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    byte[] bytes;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        LOG.info("Downloading sources JAR: " + myUrl);
                        indicator.checkCanceled();
                        bytes = HttpRequests.request((String)myUrl).readBytes(indicator);
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            String message = "Failed to download sources: " + myUrl;
                            new Notification(myMessageGroupId, "Downloading failed", message, NotificationType.ERROR).notify(this.getProject());
                            callback.setDone();
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            WriteAction.run(() -> this.storeFile(bytes));
                        }
                        finally {
                            callback.setDone();
                        }
                    });
                }

                public void onCancel() {
                    callback.setRejected();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                }
            };
            task.queue();
            return callback;
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final String myName;
        private final VirtualFile mySrcFile;
        private final Library myLibrary;

        public AttachExistingSourceAction(VirtualFile srcFile, Library library, String actionName) {
            this.mySrcFile = srcFile;
            this.myLibrary = library;
            this.myName = actionName;
        }

        public String getName() {
            return this.myName;
        }

        public String getBusyText() {
            return this.getName();
        }

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ActionCallback callback = new ActionCallback();
            callback.setDone();
            if (!this.mySrcFile.isValid()) {
                return callback;
            }
            if (this.myLibrary != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntriesContainingFile)) {
                return callback;
            }
            WriteAction.run(() -> AbstractAttachSourceProvider.this.addSourceFile(this.mySrcFile, this.myLibrary));
            return callback;
        }
    }
}

