/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.google.common.base.Predicate;
import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    private static boolean isLibraryNeedToBeReloaded(LibraryEx library, RepositoryLibraryProperties properties) {
        String version = properties.getVersion();
        if (version == null) {
            return false;
        }
        if (version.equals("LATEST") || version.equals("RELEASE") || version.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (library.getFiles(orderRootType).length == library.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    public static Set<Library> collectLibraries(@NotNull Project project2, @NotNull Predicate<? super Library> predicate) {
        if (project2 == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(0);
        }
        if (predicate == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(1);
        }
        LinkedHashSet<Library> result = new LinkedHashSet<Library>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project2 == null) {
                RepositoryLibrarySynchronizer.$$$reportNull$$$0(8);
            }
            if (predicate == null) {
                RepositoryLibrarySynchronizer.$$$reportNull$$$0(9);
            }
            if (project2.isDisposed()) {
                return;
            }
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                OrderEnumerator.orderEntries((Module)module2).withoutSdk().forEachLibrary(library -> {
                    if (predicate == null) {
                        RepositoryLibrarySynchronizer.$$$reportNull$$$0(10);
                    }
                    if (predicate.apply(library)) {
                        result.add((Library)library);
                    }
                    return true;
                });
            }
            for (Module module3 : ProjectLibraryTable.getInstance((Project)project2).getLibraries()) {
                if (!predicate.apply((Object)module3)) continue;
                result.add((Library)module3);
            }
        });
        return result;
    }

    private static void removeDuplicatedUrlsFromRepositoryLibraries(@NotNull Project project2) {
        Set<Library> libraries2;
        if (project2 == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(2);
        }
        if (!(libraries2 = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<? super Library>)((Predicate)library -> library instanceof LibraryEx && ((LibraryEx)library).getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.hasDuplicatedRoots(library)))).isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                List validLibraries;
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.$$$reportNull$$$0(7);
                }
                if ((validLibraries = ContainerUtil.filter((Collection)libraries2, LibraryTableImplUtil::isValidLibrary)).isEmpty()) {
                    return;
                }
                WriteAction.run(() -> {
                    for (Library library : validLibraries) {
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (OrderRootType type : OrderRootType.getAllTypes()) {
                            String[] urls = model.getUrls(type);
                            LinkedHashSet<String> uniqueUrls = new LinkedHashSet<String>(Arrays.asList(urls));
                            if (uniqueUrls.size() == urls.length) continue;
                            for (String url : urls) {
                                model.removeRoot(url, type);
                            }
                            for (String url : uniqueUrls) {
                                model.addRoot(url, type);
                            }
                        }
                        model.commit();
                    }
                });
                String libraryText = validLibraries.size() == 1 ? "'" + LibraryUtil.getPresentableName((Library)((Library)validLibraries.iterator().next())) + "' library" : validLibraries.size() + " libraries";
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository libraries cleanup", "Duplicated URLs were removed from " + libraryText + ". These duplicated URLs were produced due to a bug in a previous " + ApplicationNamesInfo.getInstance().getFullProductName() + " version and might cause performance issues.", NotificationType.INFORMATION), (Project)project2);
            }, project2.getDisposed());
        }
    }

    private static boolean hasDuplicatedRoots(Library library) {
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            Object[] urls = library.getUrls(type);
            if (urls.length == ContainerUtil.set((Object[])urls).size()) continue;
            return true;
        }
        return false;
    }

    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(3);
        }
        final Runnable syncTask = () -> {
            if (project2 == null) {
                RepositoryLibrarySynchronizer.$$$reportNull$$$0(5);
            }
            Set<Library> toSync = RepositoryLibrarySynchronizer.collectLibraries(project2, (Predicate<? super Library>)((Predicate)library -> {
                if (library instanceof LibraryEx) {
                    LibraryEx libraryEx = (LibraryEx)library;
                    return libraryEx.getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.isLibraryNeedToBeReloaded(libraryEx, (RepositoryLibraryProperties)libraryEx.getProperties());
                }
                return false;
            }));
            ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> {
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.$$$reportNull$$$0(6);
                }
                for (Library library : toSync) {
                    if (!LibraryTableImplUtil.isValidLibrary((Library)library)) continue;
                    RepositoryUtils.reloadDependencies(project2, (LibraryEx)library);
                }
            }), project2.getDisposed());
        };
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private final Alarm myAlarm;
            {
                this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.myAlarm.isDisposed() && event.getSource() instanceof Project) {
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(syncTask, 300L);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jarRepository/RepositoryLibrarySynchronizer$1", "rootsChanged"));
            }
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project2 == null) {
                    RepositoryLibrarySynchronizer.$$$reportNull$$$0(4);
                }
                RepositoryLibrarySynchronizer.removeDuplicatedUrlsFromRepositoryLibraries(project2);
                syncTask.run();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/RepositoryLibrarySynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDuplicatedUrlsFromRepositoryLibraries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runActivity$8";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runActivity$7";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$6";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$removeDuplicatedUrlsFromRepositoryLibraries$4";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectLibraries$1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

