/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemActionUtil {
    public static void executeAction(String actionId, InputEvent e) {
        ExternalSystemActionUtil.executeAction(actionId, "", e);
    }

    public static void executeAction(String actionId, @NotNull String place, InputEvent e) {
        ActionManager actionManager;
        AnAction action;
        if (place == null) {
            ExternalSystemActionUtil.$$$reportNull$$$0(0);
        }
        if ((action = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
            Presentation presentation = new Presentation();
            AnActionEvent event = new AnActionEvent(e, DataManager.getInstance().getDataContext(e.getComponent()), place, presentation, actionManager, 0);
            action.update(event);
            if (presentation.isEnabled()) {
                action.actionPerformed(event);
            }
        }
    }

    @Nullable
    public static Module getModule(DataContext context) {
        Module module2 = (Module)LangDataKeys.MODULE.getData(context);
        return module2 != null ? module2 : (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<? extends E> all, Collection<E> selected, Comparator<? super E> comparator) {
        List selection = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<? extends E> sorted = new TreeSet<E>(comparator);
        sorted.addAll(all);
        for (Object e : sorted) {
            chooser.addElement(e, selected.contains(e));
        }
        chooser.selectElements((Collection)selection);
    }

    public static void installCheckboxRenderer(final SimpleTree tree, final CheckboxHandler handler) {
        final JCheckBox checkbox = new JCheckBox();
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)checkbox, "West");
        final TreeCellRenderer baseRenderer = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component baseComponent = baseRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (!handler.isVisible(userObject)) {
                    return baseComponent;
                }
                Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
                Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
                panel.add(baseComponent, "Center");
                panel.setBackground(background);
                panel.setForeground(foreground);
                CheckBoxState state = handler.getState(userObject);
                checkbox.setSelected(state != CheckBoxState.UNCHECKED);
                checkbox.setEnabled(state != CheckBoxState.PARTIAL);
                checkbox.setBackground(background);
                checkbox.setForeground(foreground);
                return panel;
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    TreePath path = tree.getPathForRow(row);
                    if (!ExternalSystemActionUtil.isCheckboxEnabledFor(path, handler)) {
                        return;
                    }
                    Rectangle checkBounds = checkbox.getBounds();
                    checkBounds.setLocation(tree.getRowBounds(row).getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        handler.toggle(path, e);
                        e.consume();
                        tree.setSelectionRow(row);
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] treePaths;
                if (e.getKeyCode() == 32 && (treePaths = tree.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePaths) {
                        if (!ExternalSystemActionUtil.isCheckboxEnabledFor(treePath, handler)) continue;
                        handler.toggle(treePath, e);
                    }
                    e.consume();
                }
            }
        });
    }

    private static boolean isCheckboxEnabledFor(TreePath path, CheckboxHandler handler) {
        Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        return handler.isVisible(userObject);
    }

    @NotNull
    public static ExternalTaskExecutionInfo buildTaskInfo(@NotNull TaskData task) {
        if (task == null) {
            ExternalSystemActionUtil.$$$reportNull$$$0(1);
        }
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task.getDescription()));
        settings.setExternalSystemIdString(task.getOwner().toString());
        ExternalTaskExecutionInfo externalTaskExecutionInfo = new ExternalTaskExecutionInfo(settings, DefaultRunExecutor.EXECUTOR_ID);
        if (externalTaskExecutionInfo == null) {
            ExternalSystemActionUtil.$$$reportNull$$$0(2);
        }
        return externalTaskExecutionInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTaskInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTaskInfo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CheckBoxState {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }
}

