/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private final List<Listener> myListeners;

    public ExternalSystemShortcutsManager(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
    }

    public void init() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionId";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager$1";
                objectArray[2] = "shortcutChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file = new File(portablePath);
            result.append(file.isFile() && file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result.append(taskName);
            }
        }
        return result.toString();
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        Shortcut[] shortcuts = this.getShortcuts(projectPath, taskName);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        return this.getShortcuts(projectPath, taskName).length > 0;
    }

    public boolean hasShortcuts(@NotNull String actionId) {
        Keymap activeKeymap;
        if (actionId == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(1);
        }
        return (activeKeymap = KeymapManager.getInstance().getActiveKeymap()).getShortcuts(actionId).length > 0;
    }

    @NotNull
    private Shortcut[] getShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        if (actionId == null) {
            if (Shortcut.EMPTY_ARRAY == null) {
                ExternalSystemShortcutsManager.$$$reportNull$$$0(2);
            }
            return Shortcut.EMPTY_ARRAY;
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(3);
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void scheduleKeymapUpdate(Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    public void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(4);
        }
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        ExternalSystemKeymapExtension.clearActions(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasShortcuts";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRunConfigurationKeymapUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

