/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.PackagingElementDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class LayoutNodesDraggingObject
extends PackagingElementDraggingObject {
    private final ArtifactEditorEx myArtifactsEditor;
    private final List<PackagingElementNode<?>> myNodes;

    public LayoutNodesDraggingObject(ArtifactEditorEx artifactsEditor, List<PackagingElementNode<?>> nodes) {
        this.myArtifactsEditor = artifactsEditor;
        this.myNodes = nodes;
    }

    @Override
    public List<PackagingElement<?>> createPackagingElements(ArtifactEditorContext context) {
        ArrayList result = new ArrayList();
        for (PackagingElementNode<?> node : this.myNodes) {
            List<?> elements = node.getPackagingElements();
            for (PackagingElement element : elements) {
                result.add(ArtifactUtil.copyWithChildren(element, this.myArtifactsEditor.getContext().getProject()));
            }
        }
        return result;
    }

    @Override
    public boolean checkCanDrop() {
        return this.myArtifactsEditor.getLayoutTreeComponent().checkCanRemove(this.myNodes);
    }

    @Override
    public void beforeDrop() {
        this.myArtifactsEditor.getLayoutTreeComponent().removeNodes(this.myNodes);
    }

    @Override
    public boolean canDropInto(@NotNull PackagingElementNode node) {
        LayoutTree tree;
        TreePath path;
        if (node == null) {
            LayoutNodesDraggingObject.$$$reportNull$$$0(0);
        }
        if ((path = (tree = this.myArtifactsEditor.getLayoutTreeComponent().getLayoutTree()).getPathFor((SimpleNode)node)) != null) {
            for (PackagingElementNode<?> selectedNode : this.myNodes) {
                if (!LayoutNodesDraggingObject.pathContains(path, selectedNode, tree)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean pathContains(TreePath path, PackagingElementNode<?> node, LayoutTree tree) {
        while (path != null) {
            SimpleNode pathNode = tree.getNodeFor(path);
            if (pathNode == node) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutNodesDraggingObject", "canDropInto"));
    }
}

