/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibrarySourceItem
extends PackagingSourceItem {
    private final Library myLibrary;

    public LibrarySourceItem(@NotNull Library library) {
        if (library == null) {
            LibrarySourceItem.$$$reportNull$$$0(0);
        }
        this.myLibrary = library;
    }

    @NotNull
    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            LibrarySourceItem.$$$reportNull$$$0(1);
        }
        LibrarySourceItemPresentation librarySourceItemPresentation = new LibrarySourceItemPresentation(this.myLibrary, context);
        if (librarySourceItemPresentation == null) {
            LibrarySourceItem.$$$reportNull$$$0(2);
        }
        return librarySourceItemPresentation;
    }

    public boolean equals(Object obj) {
        return obj instanceof LibrarySourceItem && this.myLibrary.equals(((LibrarySourceItem)((Object)obj)).myLibrary);
    }

    public int hashCode() {
        return this.myLibrary.hashCode();
    }

    @NotNull
    public Library getLibrary() {
        Library library = this.myLibrary;
        if (library == null) {
            LibrarySourceItem.$$$reportNull$$$0(3);
        }
        return library;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        PackagingElementOutputKind packagingElementOutputKind = LibraryPackagingElement.getKindForLibrary(this.myLibrary);
        if (packagingElementOutputKind == null) {
            LibrarySourceItem.$$$reportNull$$$0(4);
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            LibrarySourceItem.$$$reportNull$$$0(5);
        }
        List list = PackagingElementFactory.getInstance().createLibraryElements(this.myLibrary);
        if (list == null) {
            LibrarySourceItem.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindOfProducedElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibrarySourceItemPresentation
    extends SourceItemPresentation {
        private final Library myLibrary;
        private final ArtifactEditorContext myContext;

        LibrarySourceItemPresentation(Library library, ArtifactEditorContext context) {
            this.myLibrary = library;
            this.myContext = context;
        }

        public boolean canNavigateToSource() {
            return this.myLibrary != null;
        }

        public void navigateToSource() {
            this.myContext.selectLibrary(this.myLibrary);
        }

        public String getPresentableName() {
            return LibraryUtil.getPresentableName((Library)this.myLibrary);
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            String name2;
            if (presentationData == null) {
                LibrarySourceItemPresentation.$$$reportNull$$$0(0);
            }
            if ((name2 = this.myLibrary.getName()) != null) {
                presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
                presentationData.addText(name2, mainAttributes);
                presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
            } else {
                if (((LibraryEx)this.myLibrary).isDisposed()) {
                    presentationData.addText("Invalid Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                VirtualFile[] files = this.myLibrary.getFiles(OrderRootType.CLASSES);
                if (files.length > 0) {
                    VirtualFile file = files[0];
                    presentationData.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file));
                    presentationData.addText(file.getName(), mainAttributes);
                } else {
                    presentationData.addText("Empty Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        public int getWeight() {
            return 10;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/LibrarySourceItem$LibrarySourceItemPresentation", "render"));
        }
    }
}

