/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPresentationManagerImpl
extends LibraryPresentationManager {
    private Map<LibraryKind, LibraryPresentationProvider<?>> myPresentationProviders;

    public static List<LibraryKind> getLibraryKinds(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(0);
        }
        SmartList result = new SmartList();
        PersistentLibraryKind kind = ((LibraryEx)library).getKind();
        if (kind != null) {
            result.add(kind);
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind, @NotNull P properties) {
                if (kind == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (properties == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.val$result.add(kind);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$1";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result;
    }

    @NotNull
    private static VirtualFile[] getLibraryFiles(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(1);
        }
        if (((LibraryEx)library).isDisposed()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryPresentationManagerImpl.$$$reportNull$$$0(2);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = context != null ? context.getLibraryFiles(library, OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        if (virtualFileArray == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    private <P extends LibraryProperties> LibraryPresentationProvider<P> getPresentationProvider(LibraryKind kind) {
        if (this.myPresentationProviders == null) {
            HashMap providers = new HashMap();
            for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
                providers.put((LibraryKind)libraryType.getKind(), (LibraryPresentationProvider<?>)libraryType);
            }
            for (LibraryType libraryType : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
                providers.put(libraryType.getKind(), (LibraryPresentationProvider<?>)libraryType);
            }
            this.myPresentationProviders = providers;
        }
        return this.myPresentationProviders.get(kind);
    }

    @Override
    @NotNull
    public Icon getNamedLibraryIcon(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        Icon icon;
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(4);
        }
        Icon icon2 = (icon = this.getCustomIcon(library, context)) != null ? icon : PlatformIcons.LIBRARY_ICON;
        if (icon2 == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @Override
    public Icon getCustomIcon(@NotNull Library library, StructureConfigurableContext context) {
        LibraryEx libraryEx;
        PersistentLibraryKind kind;
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(6);
        }
        if ((kind = (libraryEx = (LibraryEx)library).getKind()) != null) {
            return LibraryType.findByKind((LibraryKind)kind).getIcon(libraryEx.getProperties());
        }
        List<Icon> icons = this.getCustomIcons(library, context);
        if (icons.size() == 1) {
            return icons.get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Icon> getCustomIcons(@NotNull Library library, StructureConfigurableContext context) {
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(7);
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        SmartList icons = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)icons){
            final /* synthetic */ List val$icons;
            {
                this.val$icons = list;
            }

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind, @NotNull P properties) {
                LibraryPresentationProvider provider;
                if (kind == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (properties == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((provider = LibraryPresentationManagerImpl.this.getPresentationProvider(kind)) != null) {
                    ContainerUtil.addIfNotNull((Collection)this.val$icons, (Object)provider.getIcon(properties));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$2";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList = icons;
        if (smartList == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @Override
    public boolean isLibraryOfKind(@NotNull List<VirtualFile> files, final @NotNull LibraryKind kind) {
        if (files == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(9);
        }
        if (kind == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(10);
        }
        return !LibraryDetectionManager.getInstance().processProperties(files, new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                if (processedKind == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (properties == null) {
                    3.$$$reportNull$$$0(1);
                }
                return !kind.equals(processedKind);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processedKind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$3";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public boolean isLibraryOfKind(@NotNull Library library, @NotNull LibrariesContainer librariesContainer, final @NotNull Set<? extends LibraryKind> acceptedKinds) {
        PersistentLibraryKind type;
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(11);
        }
        if (librariesContainer == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(12);
        }
        if (acceptedKinds == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(13);
        }
        if ((type = ((LibraryEx)library).getKind()) != null && acceptedKinds.contains(type)) {
            return true;
        }
        VirtualFile[] files = librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES);
        return !LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                if (processedKind == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (properties == null) {
                    4.$$$reportNull$$$0(1);
                }
                return !acceptedKinds.contains(processedKind);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processedKind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$4";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull Library library, StructureConfigurableContext context) {
        if (library == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(14);
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        List<String> list = this.getDescriptions(files, Collections.emptySet());
        if (list == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull VirtualFile[] classRoots, final Set<LibraryKind> excludedKinds) {
        if (classRoots == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(16);
        }
        final SmartList result = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(classRoots), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind, @NotNull P properties) {
                LibraryPresentationProvider provider;
                if (kind == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (properties == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!excludedKinds.contains(kind) && (provider = LibraryPresentationManagerImpl.this.getPresentationProvider(kind)) != null) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)provider.getDescription(properties));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "properties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl$5";
                objectArray[2] = "processProperties";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @Override
    public List<Library> getLibraries(@NotNull Set<LibraryKind> kinds, @NotNull Project project2, @Nullable StructureConfigurableContext context) {
        if (kinds == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(18);
        }
        if (project2 == null) {
            LibraryPresentationManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<Library> libraries2 = new ArrayList<Library>();
        if (context != null) {
            Collections.addAll(libraries2, context.getProjectLibrariesProvider().getModifiableModel().getLibraries());
            Collections.addAll(libraries2, context.getGlobalLibrariesProvider().getModifiableModel().getLibraries());
        } else {
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            Collections.addAll(libraries2, registrar.getLibraryTable(project2).getLibraries());
            Collections.addAll(libraries2, registrar.getLibraryTable().getLibraries());
        }
        Iterator iterator = libraries2.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            List<LibraryKind> libraryKinds = LibraryPresentationManagerImpl.getLibraryKinds(library, context);
            if (ContainerUtil.intersects(libraryKinds, kinds)) continue;
            iterator.remove();
        }
        return libraries2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptedKinds";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/impl/LibraryPresentationManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedLibraryIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomIcons";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryKinds";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFiles";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamedLibraryIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomIcons";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryOfKind";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

