/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertModuleLibraryToRepositoryLibraryAction;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "classpathPanel", "Lcom/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanel;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "(Lcom/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanel;Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getSelectedLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "replaceLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "intellij.java.ui"})
public final class ConvertModuleLibraryToRepositoryLibraryAction
extends ConvertToRepositoryLibraryActionBase {
    private final ClasspathPanel classpathPanel;

    @Override
    @Nullable
    protected LibraryEx getSelectedLibrary() {
        LibraryOrderEntry entry;
        OrderEntry orderEntry = this.classpathPanel.getSelectedEntry();
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            orderEntry = null;
        }
        if ((entry = (LibraryOrderEntry)orderEntry) == null || !entry.isModuleLevel()) {
            return null;
        }
        Library library = entry.getLibrary();
        if (!(library instanceof LibraryEx)) {
            library = null;
        }
        return (LibraryEx)library;
    }

    @Override
    protected void replaceLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEditorBase, Unit> configureNewLibrary) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Intrinsics.checkParameterIsNotNull(configureNewLibrary, (String)"configureNewLibrary");
        String name2 = library.getName();
        LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = this.classpathPanel.getModifiableModelProvider("module");
        Intrinsics.checkExpressionValueIsNotNull((Object)libraryTableModifiableModelProvider, (String)"classpathPanel.getModifi\u2026bleImplUtil.MODULE_LEVEL)");
        LibraryTable.ModifiableModel modifiableModel = libraryTableModifiableModelProvider.getModifiableModel();
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)repositoryLibraryType), (String)"RepositoryLibraryType.getInstance()");
        Library library2 = modifiableModel.createLibrary(name2, repositoryLibraryType.getKind(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"modifiableModel.createLi\u2026getInstance().kind, null)");
        Library newLibrary = library2;
        ModifiableRootModel modifiableRootModel = this.classpathPanel.getRootModel();
        LibraryOrderEntry libraryOrderEntry = this.classpathPanel.getRootModel().findLibraryOrderEntry(library);
        if (libraryOrderEntry == null) {
            Intrinsics.throwNpe();
        }
        OrderEntryUtil.replaceLibraryEntryByAdded((ModifiableRootModel)modifiableRootModel, (LibraryOrderEntry)libraryOrderEntry);
        ExistingLibraryEditor editor = new ExistingLibraryEditor(newLibrary, null);
        configureNewLibrary.invoke((Object)editor);
        editor.commit();
    }

    public ConvertModuleLibraryToRepositoryLibraryAction(@NotNull ClasspathPanel classpathPanel, @NotNull StructureConfigurableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)classpathPanel, (String)"classpathPanel");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.classpathPanel = classpathPanel;
    }
}

