/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertProjectLibraryToRepositoryLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectLibrariesConfigurable
extends BaseLibrariesConfigurable {
    public ProjectLibrariesConfigurable(Project project2) {
        super(project2, "project");
    }

    protected String getComponentStateKey() {
        return "ProjectLibrariesConfigurable.UI";
    }

    @Nls
    public String getDisplayName() {
        return "Libraries";
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.libraries" == null) {
            ProjectLibrariesConfigurable.$$$reportNull$$$0(0);
        }
        return "project.libraries";
    }

    @Override
    public StructureLibraryTableModifiableModelProvider getModelProvider() {
        return this.myContext.getProjectLibrariesProvider();
    }

    @Override
    public BaseLibrariesConfigurable getOppositeGroup() {
        return GlobalLibrariesConfigurable.getInstance(this.myProject);
    }

    public static ProjectLibrariesConfigurable getInstance(Project project2) {
        return (ProjectLibrariesConfigurable)((Object)ServiceManager.getService((Project)project2, ProjectLibrariesConfigurable.class));
    }

    @Override
    public LibraryTablePresentation getLibraryTablePresentation() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getPresentation();
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        List<? extends AnAction> actions = super.createCopyActions(fromPopup);
        if (fromPopup) {
            List list = ContainerUtil.concat(actions, Collections.singletonList(new ConvertProjectLibraryToRepositoryLibraryAction(this, this.myContext)));
            if (list == null) {
                ProjectLibrariesConfigurable.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends AnAction> list = actions;
        if (list == null) {
            ProjectLibrariesConfigurable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected String getAddText() {
        return ProjectBundle.message((String)"add.new.project.library.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ProjectLibrariesConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

