/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.util.Condition;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ArtifactModelBase
implements ArtifactModel {
    private Map<String, Artifact> myArtifactsMap;
    private Artifact[] myArtifactsArray;
    public static final Condition<Artifact> VALID_ARTIFACT_CONDITION = artifact -> !(artifact instanceof InvalidArtifact);

    protected abstract List<? extends Artifact> getArtifactsList();

    @NotNull
    public Artifact[] getArtifacts() {
        if (this.myArtifactsArray == null) {
            List validArtifacts = ContainerUtil.findAll(this.getArtifactsList(), VALID_ARTIFACT_CONDITION);
            this.myArtifactsArray = validArtifacts.toArray(new Artifact[0]);
        }
        if (this.myArtifactsArray == null) {
            ArtifactModelBase.$$$reportNull$$$0(0);
        }
        return this.myArtifactsArray;
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return Collections.unmodifiableList(this.getArtifactsList());
    }

    public Artifact findArtifact(@NotNull String name2) {
        if (name2 == null) {
            ArtifactModelBase.$$$reportNull$$$0(1);
        }
        if (this.myArtifactsMap == null) {
            this.myArtifactsMap = new HashMap<String, Artifact>();
            for (Artifact artifact : this.getArtifactsList()) {
                this.myArtifactsMap.put(artifact.getName(), artifact);
            }
        }
        return this.myArtifactsMap.get(name2);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactModelBase.$$$reportNull$$$0(2);
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            ArtifactModelBase.$$$reportNull$$$0(3);
        }
        return artifact2;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactModelBase.$$$reportNull$$$0(4);
        }
        Artifact artifact2 = artifact;
        if (artifact2 == null) {
            ArtifactModelBase.$$$reportNull$$$0(5);
        }
        return artifact2;
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        if (type == null) {
            ArtifactModelBase.$$$reportNull$$$0(6);
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.getArtifacts()) {
            if (!artifact.getArtifactType().equals(type)) continue;
            result.add(artifact);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            ArtifactModelBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected void artifactsChanged() {
        this.myArtifactsMap = null;
        this.myArtifactsArray = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactModelBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactModelBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactByOriginal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactByOriginal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

