/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsCompiler
implements Compiler {
    private static final Key<Set<String>> WRITTEN_PATHS_KEY = Key.create((String)"artifacts_written_paths");
    private static final Key<Set<Artifact>> CHANGED_ARTIFACTS = Key.create((String)"affected_artifacts");

    public boolean validateConfiguration(CompileScope scope) {
        return false;
    }

    @Nullable
    public static ArtifactsCompiler getInstance(@NotNull Project project2) {
        ArtifactsCompiler[] compilers;
        if (project2 == null) {
            ArtifactsCompiler.$$$reportNull$$$0(0);
        }
        return (compilers = (ArtifactsCompiler[])CompilerManager.getInstance((Project)project2).getCompilers(ArtifactsCompiler.class)).length == 1 ? compilers[0] : null;
    }

    public static void addChangedArtifact(CompileContext context, Artifact artifact) {
        Set artifacts = (Set)context.getUserData(CHANGED_ARTIFACTS);
        if (artifacts == null) {
            artifacts = new THashSet();
            context.putUserData(CHANGED_ARTIFACTS, (Object)artifacts);
        }
        artifacts.add(artifact);
    }

    public static void addWrittenPaths(CompileContext context, Set<String> writtenPaths) {
        Set paths = (Set)context.getUserData(WRITTEN_PATHS_KEY);
        if (paths == null) {
            paths = new THashSet();
            context.putUserData(WRITTEN_PATHS_KEY, (Object)paths);
        }
        paths.addAll(writtenPaths);
    }

    @NotNull
    public String getDescription() {
        if ("Artifacts Packaging Compiler" == null) {
            ArtifactsCompiler.$$$reportNull$$$0(1);
        }
        return "Artifacts Packaging Compiler";
    }

    @Nullable
    public static Set<Artifact> getChangedArtifacts(CompileContext compileContext) {
        return (Set)compileContext.getUserData(CHANGED_ARTIFACTS);
    }

    @Nullable
    public static Set<String> getWrittenPaths(@NotNull CompileContext context) {
        if (context == null) {
            ArtifactsCompiler.$$$reportNull$$$0(2);
        }
        return (Set)context.getUserData(WRITTEN_PATHS_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/compiler/ArtifactsCompiler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/compiler/ArtifactsCompiler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWrittenPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

