/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.util.IncorrectOperationException;

public class MatcherImplUtil {
    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, FileType fileType, Project project2) throws IncorrectOperationException {
        return MatcherImplUtil.createTreeFromText(text, context, fileType, null, null, project2, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text, PatternTreeContext context, FileType fileType, String extension, Project project2, boolean physical) {
        Language language;
        StructuralSearchProfile profile2;
        if (fileType instanceof LanguageFileType && (profile2 = StructuralSearchUtil.getProfileByLanguage(language = ((LanguageFileType)fileType).getLanguage())) != null) {
            return profile2.createPatternTree(text, context, fileType, null, null, extension, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, FileType fileType, Language language, String contextName, Project project2, boolean physical) throws IncorrectOperationException {
        StructuralSearchProfile profile2;
        if (language == null && fileType instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        if (language != null && (profile2 = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            return profile2.createPatternTree(text, context, fileType, language, contextName, null, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

