/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeInfo {
    public static final FileTypeInfo[] EMPTY_ARRAY = new FileTypeInfo[0];
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final FileType myFileType;
    private final Language myDialect;
    private final String myContext;
    private final boolean myEnabled;
    private final String myDescription;

    public FileTypeInfo(@NotNull FileType fileType, @Nullable Language dialect, @Nullable String context, boolean enabled, boolean duplicated) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(0);
        }
        this.myFileType = fileType;
        this.myDialect = dialect;
        this.myContext = context;
        this.myEnabled = enabled;
        this.myDescription = FileTypeInfo.getDescription(fileType, duplicated);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(1);
        }
        return fileType;
    }

    @Nullable
    public Language getDialect() {
        return this.myDialect;
    }

    @Nullable
    public String getContext() {
        return this.myContext;
    }

    @NotNull
    public String getText() {
        if (this.myDialect != null) {
            String string = this.myDialect.getDisplayName();
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (this.myContext != null) {
            String string = this.myContext + " Context";
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myFileType.getName();
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getSearchText() {
        if (this.myDialect != null) {
            String string = this.myDialect.getDisplayName();
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myFileType.getName();
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFullText() {
        if (this.myDialect != null) {
            String string = this.myDescription + " - " + this.myDialect.getDisplayName();
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (this.myContext != null) {
            String string = this.myDescription + " - " + this.myContext + " Context";
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.myDescription;
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isNested() {
        return this.myDialect != null || this.myContext != null;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEqualTo(@NotNull FileType fileType, @Nullable Language dialect, @Nullable String context) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(10);
        }
        return Objects.equals(this.myFileType, fileType) && Objects.equals(this.myDialect, dialect) && Objects.equals(this.myContext, context);
    }

    @NotNull
    private static String getDescription(@NotNull FileType fileType, boolean duplicated) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(11);
        }
        String description = fileType.getDescription();
        String trimmedDescription = StringUtil.capitalizeWords((String)CLEANUP.matcher(description).replaceAll(""), (boolean)true);
        if (!duplicated) {
            String string = trimmedDescription;
            if (string == null) {
                FileTypeInfo.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = trimmedDescription + " (" + fileType.getName() + ")";
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeInfo)) {
            return false;
        }
        FileTypeInfo info = (FileTypeInfo)o;
        return Objects.equals(this.myFileType, info.myFileType) && Objects.equals(this.myDialect, info.myDialect) && Objects.equals(this.myContext, info.myContext);
    }

    public int hashCode() {
        return Objects.hash(this.myFileType, this.myDialect, this.myContext);
    }

    public String toString() {
        return this.getFullText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

