/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    private long modificationTimeStamp;
    private final List<String> variables;
    private final Editor editor;
    @Nullable
    private final Consumer<? super String> myCurrentVariableCallback;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");

    SubstitutionShortInfoHandler(@NotNull Editor _editor, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(0);
        }
        this.variables = new SmartList();
        this.editor = _editor;
        this.myCurrentVariableCallback = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(1);
        }
        LogicalPosition position = this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        this.handleInputFocusMovement(position, false);
    }

    private void handleInputFocusMovement(LogicalPosition position, boolean caret) {
        int start;
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        this.checkModelValidity();
        int offset = this.editor.logicalPositionToOffset(position);
        Document document = this.editor.getDocument();
        int length = document.getTextLength();
        CharSequence elements = document.getCharsSequence();
        for (start = offset - 1; start >= 0 && Character.isJavaIdentifierPart(elements.charAt(start)) && elements.charAt(start) != '$'; --start) {
        }
        String text = "";
        String variableName = null;
        int end = -1;
        if (start >= 0 && elements.charAt(start) == '$') {
            for (end = offset; end < length && Character.isJavaIdentifierPart(elements.charAt(end)) && elements.charAt(end) != '$'; ++end) {
            }
            if (end < length && elements.charAt(end) == '$' && this.variables.contains(variableName = elements.subSequence(start + 1, end).toString())) {
                NamedScriptableDefinition variable = configuration.findVariable(variableName);
                text = SubstitutionShortInfoHandler.getShortParamString(variable);
                boolean replacementVariable = variable instanceof ReplacementVariableDefinition || variable == null && configuration instanceof ReplaceConfiguration;
                String currentVariableName = replacementVariable ? variableName + "$replacement" : variableName;
                configuration.setCurrentVariableName(currentVariableName);
                if (this.myCurrentVariableCallback != null && caret) {
                    this.myCurrentVariableCallback.accept(currentVariableName);
                    caret = false;
                }
            }
        }
        if (this.myCurrentVariableCallback != null && caret) {
            this.myCurrentVariableCallback.accept("__context__");
        }
        if (variableName != null) {
            SubstitutionShortInfoHandler.showTooltip(this.editor, start, end + 1, text, variableName);
        }
    }

    private void checkModelValidity() {
        Document document = this.editor.getDocument();
        if (this.modificationTimeStamp != document.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariables((CharSequence)document.getCharsSequence()).keySet());
            this.modificationTimeStamp = document.getModificationStamp();
        }
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(2);
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(3);
        }
        this.handleInputFocusMovement(e.getNewPosition(), true);
    }

    public List<String> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition) {
        String script;
        boolean oldDialog;
        if (namedScriptableDefinition == null) {
            String string = SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]);
            if (string == null) {
                SubstitutionShortInfoHandler.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        String inactiveTextColor = ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor());
        boolean bl = oldDialog = !Registry.is((String)"ssr.use.new.search.dialog");
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            String name2;
            String text;
            MatchVariableConstraint constraint = (MatchVariableConstraint)namedScriptableDefinition;
            if (constraint.isPartOfSearchResults() && oldDialog) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (constraint.getRegExp() != null && !constraint.getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? 1 : 0, StringUtil.escapeXml((String)constraint.getRegExp()), constraint.isWholeWordsOnly() ? 1 : 0, constraint.isWithinHierarchy() ? 1 : 0, inactiveTextColor));
            } else if (constraint.isWithinHierarchy()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)constraint.getReferenceConstraint())) {
                text = StringUtil.escapeXml((String)StringUtil.unquoteString((String)constraint.getReferenceConstraint()));
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("reference.target.tooltip.message", constraint.isInvertReference() ? 1 : 0, text));
            }
            if (constraint.getNameOfExprType() != null && !constraint.getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? 1 : 0, StringUtil.escapeXml((String)constraint.getNameOfExprType()), constraint.isExprTypeWithinHierarchy() ? 1 : 0, inactiveTextColor));
            }
            if (constraint.getNameOfFormalArgType() != null && !constraint.getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? 1 : 0, StringUtil.escapeXml((String)constraint.getNameOfFormalArgType()), constraint.isFormalArgTypeWithinHierarchy() ? 1 : 0, inactiveTextColor));
            }
            if (StringUtil.isNotEmpty((String)constraint.getWithinConstraint())) {
                text = StringUtil.escapeXml((String)StringUtil.unquoteString((String)constraint.getWithinConstraint()));
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("within.constraints.tooltip.message", constraint.isInvertWithinConstraint() ? 1 : 0, text));
            }
            if (!"__context__".equals(name2 = constraint.getName())) {
                int maxCount = constraint.getMaxCount();
                int minCount = constraint.getMinCount();
                if (oldDialog || minCount != 1 || maxCount != 1) {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("min.occurs.tooltip.message", minCount, maxCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxCount)));
                }
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()) != null && script.length() > 2) {
            String str = SSRBundle.message("script.tooltip.message", StringUtil.unquoteString((String)script));
            SubstitutionShortInfoHandler.append(buf, str);
        }
        if (buf.length() == 0 && oldDialog) {
            String string = SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]);
            if (string == null) {
                SubstitutionShortInfoHandler.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = buf.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    private static void showTooltip(@NotNull Editor editor, int start, int end, @NotNull String text, String variableName) {
        if (editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(7);
        }
        if (text == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(8);
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point left = editor.logicalPositionToXY(editor.offsetToLogicalPosition(start));
        int documentLength = editor.getDocument().getTextLength();
        if (end >= documentLength) {
            end = documentLength;
        }
        Point right = editor.logicalPositionToXY(editor.offsetToLogicalPosition(end));
        Point bestPoint = new Point(left.x + (right.x - left.x) / 2, right.y + editor.getLineHeight() / 2);
        if (visibleArea.x > bestPoint.x) {
            bestPoint.x = visibleArea.x;
        } else if (visibleArea.x + visibleArea.width < bestPoint.x) {
            bestPoint.x = visibleArea.x + visibleArea.width - 5;
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, bestPoint).setAwtTooltip(true).setHighlighterType(true).setShowImmediately(true).setCalloutShift(editor.getLineHeight() / 2 - 1);
        String dressedText = Registry.is((String)"ssr.use.new.search.dialog") ? text + " <a href=\"#ssr_edit_filters/" + variableName + "\">Edit filters</a>" : text;
        TooltipController.getInstance().showTooltip(editor, p, dressedText, visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor, @Nullable Consumer<? super String> currentVariableCallback) {
        SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler);
        editor.getDocument().addDocumentListener((DocumentListener)handler);
        editor.getCaretModel().addCaretListener((CaretListener)handler);
        editor.putUserData(LISTENER_KEY, (Object)handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mouseDragged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

