/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class BaseFixture
implements IdeaTestFixture {
    private boolean myInitialized;
    private boolean myDisposed;
    private final Disposable myTestRootDisposable = Disposer.newDisposable();

    @Override
    public void setUp() throws Exception {
        Assert.assertFalse((String)"setUp() already has been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myInitialized = true;
    }

    @Override
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"setUp() has not been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.disposeRootDisposable();
        this.myDisposed = true;
        this.resetClassFields(this.getClass());
    }

    protected void disposeRootDisposable() {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (!Disposer.isDisposed((Disposable)this.myTestRootDisposable)) {
                Disposer.dispose((Disposable)this.myTestRootDisposable);
            }
        }));
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass != BaseFixture.class) {
            this.resetClassFields(aClass.getSuperclass());
        }
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            BaseFixture.$$$reportNull$$$0(0);
        }
        return disposable;
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/BaseFixture", "getTestRootDisposable"));
    }
}

