/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.codeInsight;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonNames;
import org.jetbrains.plugins.javaFX.fxml.JavaFxModuleUtil;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxFieldToPropertyIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(JavaFxFieldToPropertyIntention.class);
    public static final String FAMILY_NAME = "Convert to JavaFX property";

    @Nls
    @NotNull
    public String getFamilyName() {
        if (FAMILY_NAME == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(0);
        }
        return FAMILY_NAME;
    }

    @NotNull
    public String getText() {
        if (FAMILY_NAME == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(1);
        }
        return FAMILY_NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile file;
        PsiField field;
        if (project == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(3);
        }
        if ((field = JavaFxFieldToPropertyIntention.getField(element)) != null && (JavaFxModuleUtil.isInJavaFxProject(file = field.getContainingFile()) || JavaFxPsiUtil.isJavaFxPackageImported(file))) {
            return PropertyInfo.createPropertyInfo(field, project) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField field;
        if (project == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((field = JavaFxFieldToPropertyIntention.getField(element)) != null, (Object)"field");
        PropertyInfo property = PropertyInfo.createPropertyInfo(field, project);
        LOG.assertTrue(property != null, (Object)"propertyInfo");
        new SearchUsagesTask(project, property).queue();
    }

    @Nullable
    private static PsiField getField(@NotNull PsiElement element) {
        if (element == null) {
            JavaFxFieldToPropertyIntention.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field == null) {
            return null;
        }
        if (field.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        if (field.getTypeElement() == null) {
            return null;
        }
        if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
            return null;
        }
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ObservableObject
    extends ObservableType {
        final PsiType myType;

        ObservableObject(@NotNull PsiType type) {
            if (type == null) {
                ObservableObject.$$$reportNull$$$0(0);
            }
            super("javafx.beans.property.SimpleObjectProperty<" + type.getCanonicalText() + ">");
            this.myType = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableObject", "<init>"));
        }
    }

    static class ObservableList
    extends ObservableType {
        final PsiType myOriginalType;
        final PsiType myItemType;
        final Project myProject;

        ObservableList(@NotNull PsiType originalType, @NotNull PsiType itemType, @NotNull Project project) {
            if (originalType == null) {
                ObservableList.$$$reportNull$$$0(0);
            }
            if (itemType == null) {
                ObservableList.$$$reportNull$$$0(1);
            }
            if (project == null) {
                ObservableList.$$$reportNull$$$0(2);
            }
            super("javafx.beans.property.SimpleListProperty<" + itemType.getCanonicalText() + ">");
            this.myOriginalType = originalType;
            this.myItemType = itemType;
            this.myProject = project;
        }

        @Nullable
        private static ObservableType createObservableList(@NotNull PsiType type, @NotNull Project project) {
            PsiType itemType;
            PsiSubstitutor substitutor;
            PsiClass listClass;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass fieldClass;
            if (type == null) {
                ObservableList.$$$reportNull$$$0(3);
            }
            if (project == null) {
                ObservableList.$$$reportNull$$$0(4);
            }
            if ((fieldClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type)).getElement()) != null && (listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", GlobalSearchScope.allScope((Project)project))) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)listClass, (PsiClass)fieldClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null && (itemType = substitutor.substitute(listClass.getTypeParameters()[0])) != null) {
                return new ObservableList(type, itemType, project);
            }
            return null;
        }

        @Override
        @Nullable
        TypeConversionDescriptor findSimpleAssignmentConversion(PsiAssignmentExpression expression) {
            return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.setAll($val$)", (PsiExpression)expression);
        }

        @Override
        @NotNull
        TypeConversionDescriptor getReadConversion(PsiExpression expression) {
            TypeConversionDescriptor typeConversionDescriptor = new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression){

                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                    PsiMethod method;
                    PsiTypeElement returnTypeElement;
                    PsiCodeBlock codeBlock;
                    PsiElement blockParent;
                    PsiReturnStatement returnStatement;
                    PsiElement statementParent;
                    PsiExpression replaced;
                    PsiElement parent;
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((parent = (replaced = super.replace(expression, evaluator)).getParent()) instanceof PsiReturnStatement && (statementParent = (returnStatement = (PsiReturnStatement)parent).getParent()) instanceof PsiCodeBlock && (blockParent = (codeBlock = (PsiCodeBlock)statementParent).getParent()) instanceof PsiMethod && (returnTypeElement = (method = (PsiMethod)blockParent).getReturnTypeElement()) != null && myOriginalType.equals(method.getReturnType())) {
                        String text = "javafx.collections.ObservableList<" + myItemType.getCanonicalText() + ">";
                        PsiTypeElement newReturnTypeElement = JavaPsiFacade.getInstance((Project)myProject).getElementFactory().createTypeElementFromText(text, (PsiElement)method);
                        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)myProject);
                        javaCodeStyleManager.shortenClassReferences(returnTypeElement.replace((PsiElement)newReturnTypeElement));
                    }
                    return replaced;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList$1", "replace"));
                }
            };
            if (typeConversionDescriptor == null) {
                ObservableList.$$$reportNull$$$0(5);
            }
            return typeConversionDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemType";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadConversion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createObservableList";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ObservableString
    extends ObservableType {
        ObservableString() {
            super("javafx.beans.property.SimpleStringProperty");
        }

        @Override
        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            if (from == null) {
                ObservableString.$$$reportNull$$$0(0);
            }
            if (expression == null) {
                ObservableString.$$$reportNull$$$0(1);
            }
            if (sign == null) {
                ObservableString.$$$reportNull$$$0(2);
            }
            if (binarySign == null) {
                ObservableString.$$$reportNull$$$0(3);
            }
            return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.set($qualifier$.get() " + binarySign + " ($val$))", expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sign";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "binarySign";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableString";
            objectArray[2] = "findCompoundAssignmentConversion";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ObservablePrimitive
    extends ObservableType {
        final PsiPrimitiveType myType;

        ObservablePrimitive(@NotNull String text, @NotNull PsiPrimitiveType type) {
            if (text == null) {
                ObservablePrimitive.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ObservablePrimitive.$$$reportNull$$$0(1);
            }
            super(text);
            this.myType = type;
        }

        @Override
        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            PsiPrimitiveType unboxedType;
            if (from == null) {
                ObservablePrimitive.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                ObservablePrimitive.$$$reportNull$$$0(3);
            }
            if (sign == null) {
                ObservablePrimitive.$$$reportNull$$$0(4);
            }
            if (binarySign == null) {
                ObservablePrimitive.$$$reportNull$$$0(5);
            }
            String valueType = ((unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)from)) != null ? unboxedType : from).getCanonicalText();
            return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.set((" + valueType + ")($qualifier$.get() " + binarySign + " ($val$)))", expression);
        }

        @Override
        @Nullable
        TypeConversionDescriptor getUpdateConversion(@NotNull PsiExpression expression, @NotNull PsiJavaToken operationToken, boolean postfix) {
            IElementType tokenType;
            PsiElement parent;
            if (expression == null) {
                ObservablePrimitive.$$$reportNull$$$0(6);
            }
            if (operationToken == null) {
                ObservablePrimitive.$$$reportNull$$$0(7);
            }
            if ((parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression)) instanceof PsiExpressionStatement && ((tokenType = operationToken.getTokenType()) == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS)) {
                String sign = operationToken.getText();
                return new TypeConversionDescriptor(postfix ? "$qualifier$" + sign : sign + "$qualifier$", "$qualifier$.set($qualifier$.get()" + sign.charAt(0) + "1)", expression);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binarySign";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operationToken";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findCompoundAssignmentConversion";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUpdateConversion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ObservableType {
        final String myText;

        ObservableType(@NotNull String text) {
            if (text == null) {
                ObservableType.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Nullable
        static ObservableType createObservableType(@NotNull PsiField field, @NotNull Project project) {
            PsiType type;
            if (field == null) {
                ObservableType.$$$reportNull$$$0(1);
            }
            if (project == null) {
                ObservableType.$$$reportNull$$$0(2);
            }
            if ((type = field.getType()) instanceof PsiPrimitiveType) {
                String text = JavaFxCommonNames.ourObservablePrimitiveWrappers.get(type);
                return text != null ? new ObservablePrimitive(text, (PsiPrimitiveType)type) : null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
            if (unboxedType != null) {
                String text = JavaFxCommonNames.ourObservablePrimitiveWrappers.get(unboxedType);
                return text != null ? new ObservablePrimitive(text, unboxedType) : null;
            }
            if (type.equalsToText("java.lang.String")) {
                return new ObservableString();
            }
            if (type instanceof PsiClassType) {
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"javafx.beans.Observable")) {
                    return null;
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
                    return ObservableList.createObservableList(type, project);
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    return null;
                }
                return new ObservableObject(type);
            }
            return null;
        }

        TypeConversionDescriptor findDirectConversion(@NotNull PsiElement context, @NotNull PsiType to, @NotNull PsiType from) {
            if (context == null) {
                ObservableType.$$$reportNull$$$0(3);
            }
            if (to == null) {
                ObservableType.$$$reportNull$$$0(4);
            }
            if (from == null) {
                ObservableType.$$$reportNull$$$0(5);
            }
            PsiClass toTypeClass = PsiUtil.resolveClassInType((PsiType)to);
            LOG.assertTrue(toTypeClass != null);
            PsiElement parent = context.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression = (PsiAssignmentExpression)parent;
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType == JavaTokenType.EQ) {
                    return this.findSimpleAssignmentConversion(expression);
                }
                String sign = expression.getOperationSign().getText();
                String binarySign = sign.substring(0, sign.length() - 1);
                return this.findCompoundAssignmentConversion(from, (PsiExpression)expression, sign, binarySign);
            }
            if (parent instanceof PsiPostfixExpression) {
                PsiPostfixExpression expression = (PsiPostfixExpression)parent;
                TypeConversionDescriptor conversion = this.getUpdateConversion((PsiExpression)expression, expression.getOperationSign(), true);
                if (conversion != null) {
                    return conversion;
                }
            } else if (parent instanceof PsiPrefixExpression) {
                PsiPrefixExpression expression = (PsiPrefixExpression)parent;
                TypeConversionDescriptor conversion = this.getUpdateConversion((PsiExpression)expression, expression.getOperationSign(), false);
                if (conversion != null) {
                    return conversion;
                }
            } else if (context instanceof PsiReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
                PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
                return this.getReadConversion(expression);
            }
            return null;
        }

        @Nullable
        TypeConversionDescriptor findSimpleAssignmentConversion(PsiAssignmentExpression expression) {
            return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set($val$)", (PsiExpression)expression);
        }

        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            if (from == null) {
                ObservableType.$$$reportNull$$$0(6);
            }
            if (expression == null) {
                ObservableType.$$$reportNull$$$0(7);
            }
            if (sign == null) {
                ObservableType.$$$reportNull$$$0(8);
            }
            if (binarySign == null) {
                ObservableType.$$$reportNull$$$0(9);
            }
            return null;
        }

        @Nullable
        TypeConversionDescriptor getUpdateConversion(@NotNull PsiExpression expression, @NotNull PsiJavaToken operationToken, boolean postfix) {
            if (expression == null) {
                ObservableType.$$$reportNull$$$0(10);
            }
            if (operationToken == null) {
                ObservableType.$$$reportNull$$$0(11);
            }
            return null;
        }

        @NotNull
        TypeConversionDescriptor getReadConversion(PsiExpression expression) {
            TypeConversionDescriptor typeConversionDescriptor = new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression);
            if (typeConversionDescriptor == null) {
                ObservableType.$$$reportNull$$$0(12);
            }
            return typeConversionDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binarySign";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operationToken";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadConversion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createObservableType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findDirectConversion";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findCompoundAssignmentConversion";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getUpdateConversion";
                    break;
                }
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PropertyInfo {
        final PsiField myField;
        final PsiClass myContainingClass;
        final PsiTypeElement myTypeElement;
        final String myFieldName;
        final ObservableType myObservableType;

        private PropertyInfo(@NotNull PsiField field, @NotNull PsiClass containingClass, @NotNull PsiTypeElement typeElement, @NotNull String fieldName, @NotNull ObservableType observableType) {
            if (field == null) {
                PropertyInfo.$$$reportNull$$$0(0);
            }
            if (containingClass == null) {
                PropertyInfo.$$$reportNull$$$0(1);
            }
            if (typeElement == null) {
                PropertyInfo.$$$reportNull$$$0(2);
            }
            if (fieldName == null) {
                PropertyInfo.$$$reportNull$$$0(3);
            }
            if (observableType == null) {
                PropertyInfo.$$$reportNull$$$0(4);
            }
            this.myField = field;
            this.myContainingClass = containingClass;
            this.myTypeElement = typeElement;
            this.myFieldName = fieldName;
            this.myObservableType = observableType;
        }

        static PropertyInfo createPropertyInfo(@NotNull PsiField field, @NotNull Project project) {
            ObservableType observableType;
            if (field == null) {
                PropertyInfo.$$$reportNull$$$0(5);
            }
            if (project == null) {
                PropertyInfo.$$$reportNull$$$0(6);
            }
            String fieldName = field.getName();
            PsiClass containingClass = field.getContainingClass();
            PsiTypeElement typeElement = field.getTypeElement();
            if (fieldName != null && containingClass != null && typeElement != null && (observableType = ObservableType.createObservableType(field, project)) != null) {
                return new PropertyInfo(field, containingClass, typeElement, fieldName, observableType);
            }
            return null;
        }

        private void convertField() {
            PsiJavaCodeReferenceElement classReference;
            Project project = this.myContainingClass.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiTypeElement newTypeElement = elementFactory.createTypeElementFromText(this.myObservableType.myText, (PsiElement)this.myField);
            this.myTypeElement.replace((PsiElement)newTypeElement);
            PsiExpression initializer = this.myField.getInitializer();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(this.myFieldName, VariableKind.FIELD);
            String initializerArgs = "this,\"" + propertyName + "\"" + (initializer == null ? "" : "," + initializer.getText());
            String initializerText = "new " + this.myObservableType.myText + "(" + initializerArgs + ")";
            PsiNewExpression newInitializer = (PsiNewExpression)elementFactory.createExpressionFromText(initializerText, (PsiElement)this.myField);
            this.myField.setInitializer((PsiExpression)newInitializer);
            PsiType fieldType = this.myField.getType();
            if (PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newInitializer, (PsiNewExpression)((PsiNewExpression)this.myField.getInitializer()), (PsiType)fieldType) && (classReference = newInitializer.getClassOrAnonymousClassReference()) != null) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)classReference.getParameterList());
            }
            this.myField.setInitializer((PsiExpression)newInitializer);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat(javaCodeStyleManager.shortenClassReferences((PsiElement)this.myField));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "observableType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPropertyInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SearchUsagesTask
    extends Task.Modal {
        private final PropertyInfo myProperty;
        private Collection<PsiReference> myReferences;
        private Set<PsiFile> myFiles;

        SearchUsagesTask(@NotNull Project project, @NotNull PropertyInfo property) {
            if (project == null) {
                SearchUsagesTask.$$$reportNull$$$0(0);
            }
            if (property == null) {
                SearchUsagesTask.$$$reportNull$$$0(1);
            }
            super(project, "Searching for usages of '" + property.myFieldName + "'", true);
            this.myProperty = property;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                SearchUsagesTask.$$$reportNull$$$0(2);
            }
            ReadAction.run(() -> {
                this.myReferences = ReferencesSearch.search((PsiElement)this.myProperty.myField).findAll();
                THashSet occurrences = new THashSet();
                occurrences.add(this.myProperty.myField);
                occurrences.addAll(ContainerUtil.mapNotNull(this.myReferences, PsiReference::getElement));
                this.myFiles = ContainerUtil.map2SetNotNull((Collection)occurrences, element -> {
                    PsiFile file = element.getContainingFile();
                    return file != null && file.isPhysical() ? file : null;
                });
            });
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)("Convert '" + this.myProperty.myFieldName + "' to JavaFX property"), null, this::replaceOccurrences, (PsiFile[])this.myFiles.toArray(PsiFile.EMPTY_ARRAY));
        }

        private void replaceOccurrences() {
            LOG.assertTrue(this.myProject != null, (Object)"myProject");
            PsiField field = this.myProperty.myField;
            field.normalizeDeclaration();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            PsiType fromType = field.getType();
            PsiType toType = elementFactory.createTypeFromText(this.myProperty.myObservableType.myText, (PsiElement)field);
            try {
                TypeMigrationRules rules = new TypeMigrationRules(this.myProject);
                Set virtualFiles = ContainerUtil.map2SetNotNull(this.myFiles, PsiFile::getVirtualFile);
                rules.setBoundScope((SearchScope)GlobalSearchScope.filesScope((Project)this.myProject, (Collection)virtualFiles));
                TypeMigrationLabeler labeler = new TypeMigrationLabeler(rules, toType, this.myProject);
                labeler.getMigratedUsages(false, new PsiElement[]{field});
                for (PsiReference reference : this.myReferences) {
                    PsiExpression expression;
                    TypeConversionDescriptor conversion;
                    PsiElement refElement = reference.getElement();
                    if (!(refElement instanceof PsiExpression) || (conversion = this.myProperty.myObservableType.findDirectConversion((PsiElement)(expression = (PsiExpression)refElement), toType, fromType)) == null) continue;
                    TypeMigrationReplacementUtil.replaceExpression((PsiExpression)expression, (Project)this.myProject, (Object)conversion, (TypeEvaluator)new TypeEvaluator(null, null, this.myProject));
                }
                this.myProperty.convertField();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$SearchUsagesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

