/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections.UnwrapTagFix;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxDefaultTagInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxDefaultTagInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                PsiClass parentTagClass;
                super.visitXmlTag(tag);
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof JavaFxPropertyTagDescriptor && (parentTagClass = JavaFxPsiUtil.getTagClass(tag.getParentTag())) != null) {
                    String propertyName = JavaFxPsiUtil.getDefaultPropertyName(parentTagClass);
                    String tagName = tag.getName();
                    if (Comparing.strEqual((String)tagName, (String)propertyName) && !JavaFxDefaultTagInspection.isCollectionAssignment(parentTagClass, propertyName, tag)) {
                        TextRange startTagRange = XmlTagUtil.getStartTagRange((XmlTag)tag);
                        TextRange rangeInElement = startTagRange != null ? startTagRange.shiftRight(-tag.getTextOffset()) : null;
                        holder.registerProblem((PsiElement)tag, rangeInElement, "Default property tag could be removed", new LocalQuickFix[]{new UnwrapTagFix(tagName)});
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(3);
        }
        return xmlElementVisitor;
    }

    private static boolean isCollectionAssignment(@NotNull PsiClass parentTagClass, @NotNull String propertyName, @NotNull XmlTag tag) {
        PsiType propertyType;
        PsiClass propertyClass;
        PsiMember property;
        PsiClass tagValueClass;
        XmlTag[] subTags;
        if (parentTagClass == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(4);
        }
        if (propertyName == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            JavaFxDefaultTagInspection.$$$reportNull$$$0(6);
        }
        return (subTags = tag.getSubTags()).length != 0 && JavaFxPsiUtil.isObservableCollection(tagValueClass = JavaFxPsiUtil.getTagValueClass(subTags[subTags.length - 1])) && (property = JavaFxPsiUtil.getWritableProperties(parentTagClass).get(propertyName)) != null && JavaFxPsiUtil.isObservableCollection(propertyClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(propertyType = JavaFxPsiUtil.getWritablePropertyType(parentTagClass, (PsiElement)property))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTagClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionAssignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

