/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;

public class JpsAntInstallationImpl
extends JpsElementBase<JpsAntInstallationImpl>
implements JpsAntInstallation {
    private final File myAntHome;
    private final String myName;
    private final List<String> myClasspath;
    private final List<String> myJarDirectories;
    private static final JpsElementChildRoleBase<JpsAntInstallation> ROLE = JpsElementChildRoleBase.create((String)"ant installation");
    public static final JpsElementCollectionRole<JpsAntInstallation> COLLECTION_ROLE = JpsElementCollectionRole.create(ROLE);

    public JpsAntInstallationImpl(File antHome, String name, List<String> classpath, List<String> jarDirectories) {
        this.myAntHome = antHome;
        this.myName = name;
        this.myClasspath = classpath;
        this.myJarDirectories = jarDirectories;
    }

    @NotNull
    public JpsAntInstallationImpl createCopy() {
        JpsAntInstallationImpl jpsAntInstallationImpl = new JpsAntInstallationImpl(this.myAntHome, this.myName, this.myClasspath, this.myJarDirectories);
        if (jpsAntInstallationImpl == null) {
            JpsAntInstallationImpl.$$$reportNull$$$0(0);
        }
        return jpsAntInstallationImpl;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void applyChanges(@NotNull JpsAntInstallationImpl modified) {
        if (modified == null) {
            JpsAntInstallationImpl.$$$reportNull$$$0(1);
        }
    }

    @Override
    public File getAntHome() {
        return this.myAntHome;
    }

    @Override
    public List<String> getClasspath() {
        return JpsAntInstallationImpl.getClasspath(this.myClasspath, this.myJarDirectories);
    }

    public static List<String> getClasspath(List<String> classpath, List<String> jarDirectories) {
        ArrayList<String> result = new ArrayList<String>(classpath);
        for (String directory : jarDirectories) {
            JpsAntInstallationImpl.addAllJarsFromDirectory(result, new File(directory));
        }
        return result;
    }

    public static void addAllJarsFromDirectory(List<? super String> classpath, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".jar")) continue;
                classpath.add(file.getAbsolutePath());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/ant/model/impl/JpsAntInstallationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/ant/model/impl/JpsAntInstallationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

