/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0017J\b\u0010\u000e\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.devkit"})
public final class MoveRegistrationQuickFix
implements LocalQuickFix {
    private final Module myTargetModule;
    private final String myTargetFileName;

    @Nls
    @NotNull
    public String getName() {
        return "Move registration to " + this.myTargetFileName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Move registration to correct module";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block15: {
            PsiElement psiElement;
            XmlTag tag;
            block14: {
                XmlTag newParentTag;
                block13: {
                    PsiElement anchor;
                    Object object;
                    XmlAttribute[] xmlAttributeArray;
                    block12: {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
                        if (xmlTag == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"PsiTreeUtil.getParentOfT\u2026ss.java, false) ?: return");
                        tag = xmlTag;
                        XmlTag xmlTag2 = tag.getParentTag();
                        if (xmlTag2 == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag2, (String)"tag.parentTag ?: return");
                        XmlTag parentTag = xmlTag2;
                        XmlFile xmlFile = ComponentModuleRegistrationChecker.access$findModulePluginXmlFile(this.myTargetModule);
                        if (xmlFile == null) {
                            return;
                        }
                        XmlFile targetFile = xmlFile;
                        XmlTag xmlTag3 = targetFile.getRootTag();
                        if (xmlTag3 == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag3, (String)"targetFile.rootTag ?: return");
                        XmlTag rootTag = xmlTag3;
                        XmlTag xmlTag4 = tag.getParentTag();
                        if (xmlTag4 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag4, (String)"tag.parentTag!!");
                        Object[] objectArray = rootTag.findSubTags(xmlTag4.getName());
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootTag.findSubTags(tag.parentTag!!.name)");
                        Object[] subTags = objectArray;
                        XmlTag xmlTag5 = (XmlTag)ArraysKt.firstOrNull((Object[])subTags);
                        if (xmlTag5 == null) {
                            XmlTag xmlTag6;
                            XmlTag $receiver = xmlTag6 = rootTag.addSubTag(rootTag.createChildTag(parentTag.getLocalName(), "", null, false), false);
                            xmlAttributeArray = parentTag.getAttributes();
                            int n = xmlAttributeArray.length;
                            for (int i = 0; i < n; ++i) {
                                XmlAttribute attribute;
                                XmlAttribute xmlAttribute = attribute = xmlAttributeArray[i];
                                Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute, (String)"attribute");
                                $receiver.setAttribute(xmlAttribute.getName(), attribute.getValue());
                            }
                            xmlTag5 = xmlTag6;
                        }
                        XmlTag xmlTag7 = newParentTag = xmlTag5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag7, (String)"newParentTag");
                        Object[] objectArray2 = xmlTag7.getSubTags();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"newParentTag.subTags");
                        Object[] $receiver$iv = objectArray2;
                        xmlAttributeArray = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv))).iterator();
                        while (xmlAttributeArray.hasNext()) {
                            Object element$iv;
                            Object it;
                            int index$iv = ((Number)xmlAttributeArray.next()).intValue();
                            Object object2 = it = (element$iv = $receiver$iv[index$iv]);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                            if (!Intrinsics.areEqual((Object)object2.getName(), (Object)tag.getName())) continue;
                            object = element$iv;
                            break block12;
                        }
                        object = null;
                    }
                    if ((psiElement = (anchor = object)) == null) break block13;
                    XmlAttribute[] it = xmlAttributeArray = psiElement;
                    psiElement = newParentTag.addAfter((PsiElement)tag, anchor);
                    if (psiElement != null) break block14;
                }
                psiElement = (PsiElement)newParentTag.addSubTag(tag, false);
            }
            PsiElement newTag = psiElement;
            tag.delete();
            PsiElement psiElement2 = newTag;
            if (!(psiElement2 instanceof Navigatable)) {
                psiElement2 = null;
            }
            Navigatable navigatable = (Navigatable)psiElement2;
            if (navigatable == null) break block15;
            navigatable.navigate(true);
        }
    }

    public MoveRegistrationQuickFix(@NotNull Module myTargetModule, @NotNull String myTargetFileName) {
        Intrinsics.checkParameterIsNotNull((Object)myTargetModule, (String)"myTargetModule");
        Intrinsics.checkParameterIsNotNull((Object)myTargetFileName, (String)"myTargetFileName");
        this.myTargetModule = myTargetModule;
        this.myTargetFileName = myTargetFileName;
    }
}

