/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;

public class StatefulEpInspection
extends DevKitUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        UField[] fields;
        if (psiClass == null) {
            StatefulEpInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            StatefulEpInspection.$$$reportNull$$$0(1);
        }
        if ((fields = psiClass.getFields()).length == 0) {
            return super.checkClass(psiClass, manager, isOnTheFly);
        }
        PsiClass javaClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)psiClass, PsiClass.class);
        boolean isQuickFix2 = InheritanceUtil.isInheritor((PsiClass)javaClass, (String)LocalQuickFix.class.getCanonicalName());
        Collection<ExtensionCandidate> targets = StatefulEpInspection.findEpCandidates(javaClass);
        if (isQuickFix2 || !targets.isEmpty()) {
            boolean isProjectComponent = InheritanceUtil.isInheritor((PsiClass)javaClass, (String)ProjectComponent.class.getCanonicalName());
            boolean projectInjectableEP = ContainerUtil.find(targets, candidate -> {
                XmlTag element = (XmlTag)candidate.pointer.getElement();
                String name = element != null ? element.getName() : null;
                return "projectService".equals(name) || "projectConfigurable".equals(name);
            }) != null;
            ArrayList result = ContainerUtil.newArrayList();
            for (UField field : fields) {
                for (Class c : new Class[]{PsiElement.class, PsiReference.class, Project.class}) {
                    String message;
                    if (c == Project.class && (field.hasModifierProperty("final") || isProjectComponent || projectInjectableEP)) continue;
                    String string = c == PsiElement.class ? "Potential memory leak: don't hold PsiElement, use SmartPsiElementPointer instead" + (isQuickFix2 ? "; also see LocalQuickFixOnPsiElement" : "") : (message = "Don't use " + c.getSimpleName() + " as a field in " + (isQuickFix2 ? "quick fix" : "extension"));
                    if (!InheritanceUtil.isInheritor((PsiType)field.getType(), (String)c.getCanonicalName())) continue;
                    result.add(manager.createProblemDescriptor((PsiElement)field, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                }
            }
            return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return super.checkClass(psiClass, manager, isOnTheFly);
    }

    @NotNull
    private static Collection<ExtensionCandidate> findEpCandidates(@Nullable PsiClass javaClass) {
        String name;
        String string = name = javaClass != null ? javaClass.getName() : null;
        if (name == null) {
            List<ExtensionCandidate> list = Collections.emptyList();
            if (list == null) {
                StatefulEpInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.filter(ExtensionLocator.byPsiClass(javaClass).findCandidates(), candidate -> {
            XmlTag element = (XmlTag)candidate.pointer.getElement();
            if (element == null) {
                return false;
            }
            String forClass = element.getAttributeValue("forClass");
            return forClass == null || !forClass.contains(name);
        });
        if (list == null) {
            StatefulEpInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/StatefulEpInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/StatefulEpInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findEpCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

