/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.navigation.LineMarkerInfoHelper;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiField) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process((PsiField)element, result);
        }
    }

    private static void process(PsiField psiField, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(psiField)) {
            return;
        }
        PsiClass epClass = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveExtensionPointClass(psiField);
        if (epClass == null) {
            return;
        }
        String epName = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpName(psiField);
        if (epName == null) {
            return;
        }
        ExtensionPointLocator locator = new ExtensionPointLocator(epClass);
        List targets = ContainerUtil.filter(locator.findDirectCandidates(), candidate -> epName.equals(candidate.epName));
        if (targets.isEmpty()) {
            return;
        }
        RelatedItemLineMarkerInfo<PsiElement> info = LineMarkerInfoHelper.createExtensionPointLineMarkerInfo(targets, (PsiElement)psiField.getNameIdentifier());
        result.add(info);
    }

    @Nullable
    private static PsiClass resolveExtensionPointClass(PsiField psiField) {
        PsiType typeParameter = PsiUtil.substituteTypeParameter((PsiType)psiField.getType(), (String)ExtensionPointName.class.getName(), (int)0, (boolean)false);
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)typeParameter);
    }

    private static String resolveEpName(PsiField psiField) {
        PsiExpression initializer = psiField.getInitializer();
        PsiExpressionList expressionList = null;
        if (initializer instanceof PsiMethodCallExpression) {
            expressionList = ((PsiMethodCallExpression)initializer).getArgumentList();
        } else if (initializer instanceof PsiNewExpression) {
            expressionList = ((PsiNewExpression)initializer).getArgumentList();
        }
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression epNameExpression = expressions[0];
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        Object o = helper.computeConstantExpression((PsiElement)epNameExpression);
        return o instanceof String ? (String)o : null;
    }

    private static boolean isExtensionPointNameDeclarationField(PsiField psiField) {
        if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("static") || psiField.hasModifierProperty("abstract")) {
            return false;
        }
        if (!psiField.hasInitializer()) {
            return false;
        }
        PsiExpression initializer = psiField.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression) && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)psiField.getType());
        if (fieldClass == null) {
            return false;
        }
        return ExtensionPointName.class.getName().equals(fieldClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

