/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPsiFileImpl
extends PsiElementBase
implements PsiFileEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.LightPsiFileImpl");
    private PsiFile myOriginalFile;
    private boolean myExplicitlySetAsValid;
    private boolean myInvalidated;
    private final FileViewProvider myViewProvider;
    private final PsiManagerImpl myManager;
    private final Language myLanguage;

    public LightPsiFileImpl(@NotNull FileViewProvider provider, @NotNull Language language) {
        if (provider == null) {
            LightPsiFileImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            LightPsiFileImpl.$$$reportNull$$$0(1);
        }
        this.myOriginalFile = null;
        this.myExplicitlySetAsValid = false;
        this.myInvalidated = false;
        this.myViewProvider = provider;
        this.myManager = (PsiManagerImpl)provider.getManager();
        this.myLanguage = language;
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myInvalidated) {
            return false;
        }
        if (!this.getViewProvider().isPhysical() || this.myExplicitlySetAsValid) {
            return true;
        }
        return this.getViewProvider().getVirtualFile().isValid();
    }

    public void setIsValidExplicitly(boolean b) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExplicitlySetAsValid = b;
    }

    public String getText() {
        return this.getViewProvider().getContents().toString();
    }

    public long getModificationStamp() {
        return this.getViewProvider().getModificationStamp();
    }

    public void subtreeChanged() {
        this.clearCaches();
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    public abstract void clearCaches();

    protected LightPsiFileImpl clone() {
        FileViewProvider provider = this.getViewProvider().clone();
        LightPsiFileImpl clone = (LightPsiFileImpl)provider.getPsi(this.getLanguage());
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getViewProvider().isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            LightPsiFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LightPsiFileImpl.$$$reportNull$$$0(3);
        }
        this.checkSetName(name);
        this.subtreeChanged();
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        LightPsiFileImpl lightPsiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (lightPsiFileImpl == null) {
            LightPsiFileImpl.$$$reportNull$$$0(4);
        }
        return lightPsiFileImpl;
    }

    public void setOriginalFile(PsiFile originalFile) {
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(5);
        }
        return psiFileArray;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            LightPsiFileImpl.$$$reportNull$$$0(6);
        }
        return language;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            LightPsiFileImpl.$$$reportNull$$$0(7);
        }
        return fileViewProvider;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            LightPsiFileImpl.$$$reportNull$$$0(8);
        }
        return project;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightPsiFileImpl.$$$reportNull$$$0(9);
        }
        PsiElement child2 = this.getFirstChild();
        while (child2 != null) {
            PsiElement nextSibling = child2.getNextSibling();
            child2.accept(visitor);
            child2 = nextSibling;
        }
    }

    @Override
    public final synchronized PsiElement copy() {
        return this.clone();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(10);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    @NotNull
    public synchronized PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(11);
        }
        return psiReferenceArray;
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public synchronized PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public synchronized PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            LightPsiFileImpl.$$$reportNull$$$0(12);
        }
        return cArray;
    }

    @Override
    public boolean isContentsLoaded() {
        return true;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @NotNull
    public abstract PsiElement[] getChildren();

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children2 = this.getChildren();
        return children2.length == 0 ? null : children2[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children2 = this.getChildren();
        return children2.length == 0 ? null : children2[children2.length - 1];
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return this.getViewProvider().getContents().length();
    }

    public int getTextOffset() {
        return 0;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(13);
        }
        return this.textMatches(element.getText());
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            LightPsiFileImpl.$$$reportNull$$$0(14);
        }
        return text.equals(this.getViewProvider().getContents());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(15);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(16);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            LightPsiFileImpl.$$$reportNull$$$0(17);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            LightPsiFileImpl.$$$reportNull$$$0(18);
        }
        if (last == null) {
            LightPsiFileImpl.$$$reportNull$$$0(19);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not implemented");
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            LightPsiFileImpl.$$$reportNull$$$0(20);
        }
        throw new IncorrectOperationException("Not implemented");
    }

    public FileASTNode getNode() {
        return null;
    }

    public abstract LightPsiFileImpl copyLight(FileViewProvider var1);

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/LightPsiFileImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/LightPsiFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

