/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ShowExternalSystemSettingsAction
extends ExternalSystemAction {
    public ShowExternalSystemSettingsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowExternalSystemSettingsAction.$$$reportNull$$$0(0);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        if (systemId == null) {
            return false;
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{systemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{systemId.getReadableName()}));
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSystemId systemId;
        if (e == null) {
            ShowExternalSystemSettingsAction.$$$reportNull$$$0(1);
        }
        if ((systemId = this.getSystemId(e)) != null) {
            Project project = this.getProject(e);
            ExternalSystemActionsCollector.trigger(project, systemId, this, e, new String[0]);
            ShowExternalSystemSettingsAction.showSettingsFor(project, systemId);
        }
    }

    protected static void showSettingsFor(Project project, @NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            ShowExternalSystemSettingsAction.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, systemId.getReadableName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/ShowExternalSystemSettingsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showSettingsFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

