/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleConfigurationImporter;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleImporterExtensionManager;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/CodeStyleConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "importCommonSettings", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "langCfg", "", "ForceEnum", "intellij.platform.externalSystem.impl"})
public final class CodeStyleConfigurationHandler
implements ConfigurationHandler {
    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Map map;
        CodeStyleSettings styleSettings;
        CodeStyleSettings codeStyleSettings;
        CodeStyleScheme importedScheme;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String importedSchemeName = "Gradle Imported";
        Object object = configuration.find("codeStyle");
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map2 = (Map)object;
        if (map2 == null) {
            return;
        }
        Map codeStyleSettings2 = map2;
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        CodeStyleScheme codeStyleScheme = schemes.findPreferredScheme(importedSchemeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleScheme, (String)"schemes.findPreferredScheme(importedSchemeName)");
        CodeStyleScheme existingScheme = codeStyleScheme;
        if (Intrinsics.areEqual((Object)existingScheme.getName(), (Object)importedSchemeName)) {
            schemes.deleteScheme(existingScheme);
        }
        CodeStyleSchemes codeStyleSchemes = schemes;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSchemes, (String)"schemes");
        CodeStyleScheme codeStyleScheme2 = importedScheme = schemes.createNewScheme(importedSchemeName, codeStyleSchemes.getDefaultScheme());
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleScheme2, (String)"importedScheme");
        CodeStyleSettings codeStyleSettings3 = codeStyleScheme2.getCodeStyleSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings3, (String)"importedScheme.codeStyleSettings");
        CodeStyleSettings $receiver = codeStyleSettings = (styleSettings = codeStyleSettings3);
        ObjectUtils.consumeIfCast(codeStyleSettings2.get("USE_SAME_INDENTS"), Boolean.TYPE, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CodeStyleSettings receiver$0;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.receiver$0.USE_SAME_INDENTS = bl;
            }
            {
                this.receiver$0 = codeStyleSettings;
            }
        });
        ObjectUtils.consumeIfCast(codeStyleSettings2.get("RIGHT_MARGIN"), Number.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CodeStyleSettings receiver$0;

            public final void consume(Number it) {
                this.receiver$0.setDefaultRightMargin(it.intValue());
            }
            {
                this.receiver$0 = codeStyleSettings;
            }
        });
        ObjectUtils.consumeIfCast(codeStyleSettings2.get("KEEP_CONTROL_STATEMENT_IN_ONE_LINE"), Boolean.TYPE, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CodeStyleSettings receiver$0;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.receiver$0.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = bl;
            }
            {
                this.receiver$0 = codeStyleSettings;
            }
        });
        List languages = CollectionsKt.listOf((Object[])new String[]{"java", "groovy"});
        Object v = codeStyleSettings2.get("languages");
        if (!(v instanceof Map)) {
            v = null;
        }
        if ((map = (Map)v) == null) {
            map = MapsKt.emptyMap();
        }
        Map importedLangs = map;
        Iterable $receiver$iv = languages;
        for (Object element$iv : $receiver$iv) {
            String langName = (String)element$iv;
            ObjectUtils.consumeIfCast(importedLangs.get(langName), Map.class, (Consumer)new Consumer<T>(langName, this, importedLangs, styleSettings){
                final /* synthetic */ String $langName;
                final /* synthetic */ CodeStyleConfigurationHandler this$0;
                final /* synthetic */ Map $importedLangs$inlined;
                final /* synthetic */ CodeStyleSettings $styleSettings$inlined;
                {
                    this.$langName = string;
                    this.this$0 = codeStyleConfigurationHandler;
                    this.$importedLangs$inlined = map;
                    this.$styleSettings$inlined = codeStyleSettings;
                }

                public final void consume(Map<?, ?> langCfg) {
                    CodeStyleConfigurationImporter<CustomCodeStyleSettings> importer = CodeStyleImporterExtensionManager.Companion.importerForLang(this.$langName);
                    if (importer != null) {
                        CommonCodeStyleSettings commonCodeStyleSettings = this.$styleSettings$inlined.getCommonSettings(importer.getLanguage());
                        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"styleSettings.getCommonSettings(importer.language)");
                        Map<?, ?> map = langCfg;
                        Intrinsics.checkExpressionValueIsNotNull(map, (String)"langCfg");
                        CodeStyleConfigurationHandler.access$importCommonSettings(this.this$0, commonCodeStyleSettings, map);
                        importer.processSettings(this.$styleSettings$inlined.getCustomSettings(importer.getCustomClass()), langCfg);
                    }
                }
            });
        }
        schemes.addScheme(importedScheme);
        schemes.setCurrentScheme(importedScheme);
    }

    private final void importCommonSettings(CommonCodeStyleSettings commonSettings, Map<?, ?> langCfg) {
        CommonCodeStyleSettings commonCodeStyleSettings;
        CommonCodeStyleSettings $receiver = commonCodeStyleSettings = commonSettings;
        Map<?, ?> map = langCfg;
        String string = "RIGHT_MARGIN";
        ObjectUtils.consumeIfCast(map.get(string), Number.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(Number it) {
                this.receiver$0.RIGHT_MARGIN = it.intValue();
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "WRAP_COMMENTS";
        ObjectUtils.consumeIfCast(map.get(string), Boolean.TYPE, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.receiver$0.WRAP_COMMENTS = bl;
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "IF_BRACE_FORCE";
        ObjectUtils.consumeIfCast(map.get(string), String.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.receiver$0.IF_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "DOWHILE_BRACE_FORCE";
        ObjectUtils.consumeIfCast(map.get(string), String.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.receiver$0.DOWHILE_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "WHILE_BRACE_FORCE";
        ObjectUtils.consumeIfCast(map.get(string), String.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.receiver$0.WHILE_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "FOR_BRACE_FORCE";
        ObjectUtils.consumeIfCast(map.get(string), String.class, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                this.receiver$0.FOR_BRACE_FORCE = ForceEnum.valueOf(string).getIndex();
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
        map = langCfg;
        string = "KEEP_CONTROL_STATEMENT_IN_ONE_LINE";
        ObjectUtils.consumeIfCast(map.get(string), Boolean.TYPE, (Consumer)new Consumer<T>($receiver){
            final /* synthetic */ CommonCodeStyleSettings receiver$0;

            public final void consume(Boolean it) {
                Boolean bl = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"it");
                this.receiver$0.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = bl;
            }
            {
                this.receiver$0 = commonCodeStyleSettings;
            }
        });
    }

    public static final /* synthetic */ void access$importCommonSettings(CodeStyleConfigurationHandler $this, @NotNull CommonCodeStyleSettings commonSettings, @NotNull Map langCfg) {
        $this.importCommonSettings(commonSettings, langCfg);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/CodeStyleConfigurationHandler$ForceEnum;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "DO_NOT_FORCE", "FORCE_BRACES_IF_MULTILINE", "FORCE_BRACES_ALWAYS", "intellij.platform.externalSystem.impl"})
    public static final class ForceEnum
    extends Enum<ForceEnum> {
        public static final /* enum */ ForceEnum DO_NOT_FORCE;
        public static final /* enum */ ForceEnum FORCE_BRACES_IF_MULTILINE;
        public static final /* enum */ ForceEnum FORCE_BRACES_ALWAYS;
        private static final /* synthetic */ ForceEnum[] $VALUES;
        private final int index;

        static {
            ForceEnum[] forceEnumArray = new ForceEnum[3];
            ForceEnum[] forceEnumArray2 = forceEnumArray;
            forceEnumArray[0] = DO_NOT_FORCE = new ForceEnum(0);
            forceEnumArray[1] = FORCE_BRACES_IF_MULTILINE = new ForceEnum(1);
            forceEnumArray[2] = FORCE_BRACES_ALWAYS = new ForceEnum(3);
            $VALUES = forceEnumArray;
        }

        public final int getIndex() {
            return this.index;
        }

        protected ForceEnum(int index) {
            this.index = index;
        }

        public static ForceEnum[] values() {
            return (ForceEnum[])$VALUES.clone();
        }

        public static ForceEnum valueOf(String string) {
            return Enum.valueOf(ForceEnum.class, string);
        }
    }
}

